/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.dithering;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.Customizable;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.TimeIntensiveOperation;
import com.t_oster.liblasercut.platform.Util;
import java.util.Arrays;

public abstract class DitheringAlgorithm
extends TimeIntensiveOperation
implements Customizable,
Cloneable {
    protected void setBlack(GreyscaleRaster src, BlackWhiteRaster target, int x, int y, boolean black) {
        if (target != null) {
            target.setBlack(x, y, black);
        } else {
            src.setGreyScale(x, y, black ? 0 : 255);
        }
    }

    public BlackWhiteRaster dither(GreyscaleRaster input) {
        BlackWhiteRaster target = new BlackWhiteRaster(input.getWidth(), input.getHeight());
        this.doDithering(input, target);
        return target;
    }

    public void ditherDirect(GreyscaleRaster input) {
        this.doDithering(input, null);
    }

    public void ditherDirect(GreyscaleRaster input, BlackWhiteRaster output) {
        this.doDithering(input, output);
    }

    protected abstract void doDithering(GreyscaleRaster var1, BlackWhiteRaster var2);

    @Override
    public String[] getPropertyKeys() {
        return new String[0];
    }

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public Object getProperty(String key) {
        return null;
    }

    public abstract DitheringAlgorithm clone();

    public abstract String toString();

    public boolean equals(Object o) {
        Object[] ot;
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DitheringAlgorithm other = (DitheringAlgorithm)o;
        Object[] own = this.getPropertyKeys();
        if (!Arrays.deepEquals(own, ot = other.getPropertyKeys())) {
            return false;
        }
        for (int i = 0; i < own.length; ++i) {
            Object key = own[i];
            if (Util.differ(this.getProperty((String)key), other.getProperty((String)key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash += this.getClass().hashCode();
        for (String key : this.getPropertyKeys()) {
            hash += key.hashCode();
            hash += this.getProperty(key).hashCode();
        }
        return hash;
    }
}

