/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.ProgressListener;
import java.util.LinkedList;
import java.util.List;

public abstract class TimeIntensiveOperation {
    private List<ProgressListener> listeners = null;
    private int progress = 0;

    private List<ProgressListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<ProgressListener>();
        }
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener l) {
        List<ProgressListener> list = this.getListeners();
        synchronized (list) {
            this.getListeners().add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener l) {
        List<ProgressListener> list = this.getListeners();
        synchronized (list) {
            this.getListeners().remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProgressChanged(int progress) {
        List<ProgressListener> list = this.getListeners();
        synchronized (list) {
            for (ProgressListener l : this.getListeners()) {
                l.progressChanged(this, progress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTaskChanged(String name) {
        List<ProgressListener> list = this.getListeners();
        synchronized (list) {
            for (ProgressListener l : this.getListeners()) {
                l.taskChanged(this, name);
            }
        }
    }

    protected void setProgress(int progress) {
        if (progress != this.progress) {
            this.progress = progress;
            this.fireProgressChanged(this.progress);
        }
    }
}

