/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.platform.Point;
import java.util.LinkedList;
import java.util.List;

public class RasterPart
extends JobPart {
    BlackWhiteRaster image = null;
    LaserProperty property = null;
    Point start = null;
    double resolution = 500.0;

    public RasterPart(BlackWhiteRaster image, LaserProperty laserProperty, Point offset, double resolution) {
        this.image = image;
        this.property = laserProperty;
        this.start = offset;
        this.resolution = resolution;
    }

    @Override
    public double getDPI() {
        return this.resolution;
    }

    @Override
    public int getMinX() {
        return this.start.x;
    }

    @Override
    public int getMaxX() {
        return this.start.x + this.image.getWidth();
    }

    @Override
    public int getMinY() {
        return this.start.y;
    }

    @Override
    public int getMaxY() {
        return this.start.y + this.image.getHeight();
    }

    public Point getRasterStart() {
        return this.start;
    }

    public List<Byte> getRasterLine(int line) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        for (int x = 0; x < (this.image.getWidth() + 7) / 8; ++x) {
            result.add(this.image.getByte(x, line));
        }
        return result;
    }

    public boolean isBlack(int x, int y) {
        return this.image.isBlack(x, y);
    }

    public int getRasterWidth() {
        return this.image.getWidth();
    }

    public int getRasterHeight() {
        return this.image.getHeight();
    }

    public LaserProperty getLaserProperty() {
        return this.property;
    }
}

