/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.platform.Util;
import java.util.LinkedList;
import java.util.List;

public class LaserJob {
    private String title;
    private String name;
    private String user;
    private double startX = 0.0;
    private double startY = 0.0;
    private List<JobPart> parts = new LinkedList<JobPart>();

    public LaserJob(String title, String name, String user) {
        this.title = title;
        this.name = name;
        this.user = user;
    }

    public void setStartPoint(double x, double y) {
        this.startX = x;
        this.startY = y;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public void addPart(JobPart p) {
        this.parts.add(p);
    }

    public void removePart(JobPart p) {
        this.parts.remove(p);
    }

    public List<JobPart> getParts() {
        return this.parts;
    }

    public void applyStartPoint() {
        if (this.startX != 0.0 || this.startY != 0.0) {
            for (JobPart p : this.getParts()) {
                JobPart rp;
                if (p instanceof VectorPart) {
                    for (VectorCommand c : ((VectorPart)p).getCommandList()) {
                        if (!c.getType().equals((Object)VectorCommand.CmdType.LINETO) && !c.getType().equals((Object)VectorCommand.CmdType.MOVETO)) continue;
                        c.setX((int)((double)c.getX() - Util.mm2inch(this.startX) * p.getDPI()));
                        c.setY((int)((double)c.getY() - Util.mm2inch(this.startY) * p.getDPI()));
                    }
                    continue;
                }
                if (p instanceof RasterPart) {
                    rp = (RasterPart)p;
                    rp.start.x -= (int)(Util.mm2inch(this.startX) * p.getDPI());
                    rp.start.y -= (int)(Util.mm2inch(this.startY) * p.getDPI());
                    continue;
                }
                if (!(p instanceof Raster3dPart)) continue;
                rp = (Raster3dPart)p;
                ((Raster3dPart)rp).start.x -= (int)(Util.mm2inch(this.startX) * p.getDPI());
                ((Raster3dPart)rp).start.y -= (int)(Util.mm2inch(this.startY) * p.getDPI());
            }
            this.startX = 0.0;
            this.startY = 0.0;
        }
    }
}

