/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.TimeIntensiveOperation;
import com.t_oster.liblasercut.dithering.Average;
import com.t_oster.liblasercut.dithering.DitheringAlgorithm;
import com.t_oster.liblasercut.dithering.FloydSteinberg;
import com.t_oster.liblasercut.dithering.Grid;
import com.t_oster.liblasercut.dithering.Ordered;
import com.t_oster.liblasercut.dithering.Random;

public class BlackWhiteRaster
extends TimeIntensiveOperation {
    private int width;
    private int height;
    private byte[][] raster;

    public static DitheringAlgorithm getDitheringAlgorithm(DitherAlgorithm alg) {
        switch (alg) {
            case FLOYD_STEINBERG: {
                return new FloydSteinberg();
            }
            case AVERAGE: {
                return new Average();
            }
            case RANDOM: {
                return new Random();
            }
            case ORDERED: {
                return new Ordered();
            }
            case GRID: {
                return new Grid();
            }
        }
        throw new IllegalArgumentException("Desired Dithering Algorithm (" + (Object)((Object)alg) + ") does not exist");
    }

    public BlackWhiteRaster(GreyscaleRaster src, DitheringAlgorithm alg, ProgressListener listener) {
        if (listener != null) {
            this.addProgressListener(listener);
        }
        this.width = src.getWidth();
        this.height = src.getHeight();
        this.raster = new byte[(src.getWidth() + 7) / 8][src.getHeight()];
        if (listener != null) {
            alg.addProgressListener(listener);
        }
        alg.ditherDirect(src, this);
    }

    public BlackWhiteRaster(GreyscaleRaster src, DitherAlgorithm dither_algorithm, ProgressListener listener) {
        this(src, BlackWhiteRaster.getDitheringAlgorithm(dither_algorithm), listener);
    }

    public BlackWhiteRaster(GreyscaleRaster src, DitherAlgorithm dither_algorithm) {
        this(src, dither_algorithm, null);
    }

    public BlackWhiteRaster(GreyscaleRaster src, DitheringAlgorithm alg) {
        this(src, alg, null);
    }

    public BlackWhiteRaster(int width, int height, byte[][] raster) {
        this.width = width;
        this.height = height;
        this.raster = raster;
    }

    public BlackWhiteRaster(int width, int height) {
        this.width = width;
        this.height = height;
        this.raster = new byte[(width + 7) / 8][height];
    }

    public boolean isBlack(int x, int y) {
        int bx = x / 8;
        int ix = 7 - x % 8;
        return (this.raster[bx][y] & 0xFF & (int)Math.pow(2.0, ix)) != 0;
    }

    public void setBlack(int x, int y, boolean black) {
        int bx = x / 8;
        int ix = 7 - x % 8;
        this.raster[bx][y] = (byte)(this.raster[bx][y] & 0xFF & ~((int)Math.pow(2.0, ix)) | (black ? (int)Math.pow(2.0, ix) : 0));
    }

    public byte getByte(int x, int y) {
        return this.raster[x][y];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum DitherAlgorithm {
        FLOYD_STEINBERG,
        AVERAGE,
        RANDOM,
        ORDERED,
        GRID;

    }
}

