/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.utils;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.TimeIntensiveOperation;
import com.t_oster.liblasercut.platform.Point;
import java.util.LinkedList;
import java.util.List;

public class ShapeRecognizer
extends TimeIntensiveOperation {
    private boolean outerBlack = false;
    private Direction previous = Direction.west;

    public List<Point> getOuterShape(BlackWhiteRaster bwr) {
        int w = bwr.getWidth();
        int h = bwr.getHeight();
        LinkedList<Point> result = new LinkedList<Point>();
        this.outerBlack = bwr.isBlack(0, 0);
        Point current = null;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < h; ++x) {
                if (bwr.isBlack(x, y) == this.outerBlack) continue;
                current = new Point(x, y);
            }
        }
        if (current == null) {
            result.add(new Point(0, 0));
            result.add(new Point(w, 0));
            result.add(new Point(w, h));
            result.add(new Point(0, h));
            result.add(new Point(0, 0));
            return result;
        }
        Point first = current.clone();
        Point before = null;
        while (current != null && current != first) {
            result.add(current);
            Point next = this.getFollower(bwr, current, before);
            before = current;
            current = next;
        }
        return null;
    }

    private Point getFollower(BlackWhiteRaster bwr, Point c, Point p) {
        int ydiff;
        int xdiff = p == null ? 1 : c.x - p.x;
        int n = ydiff = p == null ? 0 : c.y - p.y;
        if (bwr.isBlack(c.x - ydiff, c.y + xdiff) == this.outerBlack) {
            return new Point(c.x - ydiff, c.y - xdiff);
        }
        if (bwr.isBlack(c.x + xdiff, c.y + xdiff) == this.outerBlack) {
            return new Point(c.x - ydiff, c.y - xdiff);
        }
        return null;
    }

    private static enum Direction {
        east,
        north_east,
        north,
        north_west,
        west,
        south_west,
        south,
        south_east;

    }
}

