/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.utils;

import com.t_oster.liblasercut.GreyscaleRaster;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class BufferedImageAdapter
implements GreyscaleRaster {
    private BufferedImage img;
    private int colorShift = 0;
    private boolean invertColors = false;

    public BufferedImageAdapter(BufferedImage img) {
        this(img, false);
    }

    public BufferedImageAdapter(BufferedImage img, boolean invertColors) {
        this.img = img;
        this.invertColors = invertColors;
    }

    public void setColorShift(int cs) {
        this.colorShift = cs;
    }

    public int getColorShift() {
        return this.colorShift;
    }

    @Override
    public int getGreyScale(int x, int line) {
        Color c = new Color(this.img.getRGB(x, line));
        int value = this.colorShift + (int)(0.3 * (double)c.getRed() + 0.59 * (double)c.getGreen() + 0.11 * (double)c.getBlue());
        return this.invertColors ? 255 - Math.max(Math.min(value, 255), 0) : Math.max(Math.min(value, 255), 0);
    }

    @Override
    public void setGreyScale(int x, int y, int grey) {
        Color c = new Color(grey, grey, grey);
        this.img.setRGB(x, y, c.getRGB());
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }
}

