/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.platform;

import com.t_oster.liblasercut.platform.Point;

public class Rectangle {
    private int x1;
    private int x2;
    private int y1;
    private int y2;

    public Rectangle(int x1, int y1, int x2, int y2) {
        this.x1 = Math.min(x1, x2);
        this.x2 = Math.max(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
    }

    public Rectangle(Point p1, Point p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public Rectangle(Point p) {
        this(p, p);
    }

    public void add(int x, int y) {
        if (x < this.x1) {
            this.x1 = x;
        } else if (x > this.x2) {
            this.x2 = x;
        }
        if (y < this.y1) {
            this.y1 = y;
        } else if (y > this.y2) {
            this.y2 = y;
        }
    }

    public void add(Point p) {
        if (p != null) {
            this.add(p.x, p.y);
        }
    }

    public int getXMin() {
        return this.x1;
    }

    public int getXMax() {
        return this.x2;
    }

    public int getYMin() {
        return this.y1;
    }

    public int getYMax() {
        return this.y2;
    }

    private Interval getXInterval() {
        return new Interval(this.x1, this.x2);
    }

    private Interval getYInterval() {
        return new Interval(this.y1, this.y2);
    }

    public String toString() {
        return "Rectangle(x1=" + this.x1 + ",y1=" + this.y1 + ",x2=" + this.x2 + ",y2=" + this.y2 + ")";
    }

    public Rectangle clone() {
        return new Rectangle(this.x1, this.y1, this.x2, this.y2);
    }

    public boolean isInsideOf(Rectangle other) {
        return this.getXInterval().isSubsetOf(other.getXInterval()) && this.getYInterval().isSubsetOf(other.getYInterval());
    }

    public boolean intersects(Rectangle other) {
        return this.getXInterval().intersects(other.getXInterval()) && this.getYInterval().intersects(other.getYInterval());
    }

    private class Interval {
        private int min;
        private int max;

        private Interval(int min, int max) {
            this.min = min;
            this.max = max;
            if (min > max) {
                throw new RuntimeException("Interval: min must be < max");
            }
        }

        private boolean isSubsetOf(Interval o) {
            return o.min <= this.min && o.max >= this.max;
        }

        private boolean intersects(Interval o) {
            return o.min >= this.min && o.min <= this.max || o.max >= this.min && o.max <= this.max;
        }
    }
}

