/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.laserscript;

import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.laserscript.ScriptInterface;
import java.awt.geom.AffineTransform;

public class VectorPartScriptInterface
implements ScriptInterface {
    private VectorPart vp;
    private AffineTransform objectTrans;

    public VectorPartScriptInterface(VectorPart vp, AffineTransform objectTrans) {
        this.vp = vp;
        this.objectTrans = objectTrans;
    }

    @Override
    public void move(double x, double y) {
        double[] p = new double[2];
        this.objectTrans.transform(new double[]{x, y}, 0, p, 0, 1);
        this.vp.moveto((int)p[0], (int)p[1]);
    }

    @Override
    public void line(double x, double y) {
        double[] p = new double[2];
        this.objectTrans.transform(new double[]{x, y}, 0, p, 0, 1);
        this.vp.lineto((int)p[0], (int)p[1]);
    }

    @Override
    public void set(String property, Object value) {
        LaserProperty cp = this.vp.getCurrentCuttingProperty().clone();
        Object current = cp.getProperty(property);
        if (current instanceof Float) {
            cp.setProperty(property, Float.valueOf(((Double)value).floatValue()));
        } else if (current instanceof Integer) {
            cp.setProperty(property, ((Double)value).intValue());
        } else if (current instanceof String) {
            cp.setProperty(property, current.toString());
        } else {
            cp.setProperty(property, value);
        }
        this.vp.setProperty(cp);
    }

    @Override
    public Object get(String property) {
        return this.vp.getCurrentCuttingProperty().getProperty(property);
    }

    @Override
    public void echo(String text) {
        System.err.println("LaserScript: " + text);
    }
}

