/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.laserscript;

import com.t_oster.liblasercut.laserscript.ScriptInterface;
import com.t_oster.liblasercut.laserscript.ScriptingSecurity;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.script.ScriptException;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class ScriptInterpreter {
    public void execute(String script, ScriptInterface si) throws ScriptException, IOException {
        this.execute(new StringReader(script), si, true);
    }

    public void execute(Reader script, ScriptInterface si) throws ScriptException, IOException {
        this.execute(script, si, true);
    }

    public void execute(String script, ScriptInterface si, boolean sandbox) throws ScriptException, IOException {
        this.execute(new StringReader(script), si, sandbox);
    }

    public void execute(Reader script, ScriptInterface si, boolean sandbox) throws ScriptException, IOException {
        if (!ContextFactory.hasExplicitGlobal()) {
            ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
        }
        Context cx = ContextFactory.getGlobal().enter();
        try {
            cx.setClassShutter((ClassShutter)ScriptingSecurity.getInstance());
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Scriptable scope = cx.initStandardObjects(null);
        scope.put("_instance", scope, (Object)Context.toObject((Object)si, (Scriptable)scope));
        ScriptingSecurity.getInstance().setLocked(false);
        cx.evaluateReader(scope, (Reader)new InputStreamReader(this.getClass().getResourceAsStream("LaserScriptBootstrap.js")), "LaserScriptBootstrap.js", -1, null);
        ScriptingSecurity.getInstance().setLocked(sandbox);
        try {
            cx.evaluateReader(scope, script, "laserscript", -1, null);
        }
        catch (Exception e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
    }

    public class SandboxContextFactory
    extends ContextFactory {
        protected Context makeContext() {
            Context cx = super.makeContext();
            cx.setWrapFactory((WrapFactory)new SandboxWrapFactory());
            return cx;
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }

    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                System.err.println("ScriptingSecurity: LaserScript tried to access 'getClass'");
                return NOT_FOUND;
            }
            return super.get(name, start);
        }
    }
}

