/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.examples;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.PowerSpeedFocusProperty;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.drivers.EpilogZing;
import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.platform.Util;
import com.t_oster.liblasercut.utils.BufferedImageAdapter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotoPrint {
    private static void error(String text) {
        JOptionPane.showMessageDialog(null, text, "An Error occured", 0);
        System.exit(1);
    }

    public static void main(String[] args) throws IllegalJobException, SocketTimeoutException, Exception {
        JFileChooser importFileChooser = new JFileChooser();
        importFileChooser.showOpenDialog(null);
        File toImport = importFileChooser.getSelectedFile();
        BufferedImage img = null;
        if (toImport == null) {
            PhotoPrint.error("No file selected");
        }
        try {
            img = ImageIO.read(toImport);
        }
        catch (IOException ex) {
            PhotoPrint.error(ex.getMessage());
        }
        int dpi = 500;
        try {
            dpi = Integer.parseInt(JOptionPane.showInputDialog(null, "Please select DPI", "" + dpi));
        }
        catch (NumberFormatException e) {
            PhotoPrint.error(e.getMessage());
        }
        int width = 50;
        try {
            width = Integer.parseInt(JOptionPane.showInputDialog(null, "Please select width in mm", "" + width));
        }
        catch (NumberFormatException e) {
            PhotoPrint.error(e.getMessage());
        }
        int oWidth = (int)Util.mm2px(width, dpi);
        int oHeight = img.getHeight() * oWidth / img.getWidth();
        final BufferedImage scaledImg = new BufferedImage(oWidth, oHeight, 1);
        Graphics2D g = scaledImg.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance((double)oWidth / (double)img.getWidth(), (double)oHeight / (double)img.getHeight());
        g.drawRenderedImage(img, at);
        final BufferedImage outImg = new BufferedImage(scaledImg.getWidth(), scaledImg.getHeight(), 1);
        final JComboBox<BlackWhiteRaster.DitherAlgorithm> cbDa = new JComboBox<BlackWhiteRaster.DitherAlgorithm>();
        for (BlackWhiteRaster.DitherAlgorithm da : BlackWhiteRaster.DitherAlgorithm.values()) {
            cbDa.addItem(da);
        }
        final JPanel prev = new JPanel();
        final JCheckBox cbInvert = new JCheckBox("invert");
        JCheckBox cbCut = new JCheckBox("Cut out the image");
        prev.setLayout(new BoxLayout(prev, 1));
        ImageIcon imgIc = new ImageIcon();
        final BufferedImage buf = new BufferedImage(400, 400, 1);
        imgIc.setImage(buf);
        final JLabel lab = new JLabel(imgIc);
        final JSlider filter = new JSlider(-255, 255, 0);
        filter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int diff = filter.getValue();
            }
        });
        prev.add(lab);
        prev.add(cbDa);
        prev.add(cbInvert);
        prev.add(cbCut);
        prev.add(filter);
        prev.add(new JLabel("Width: " + outImg.getWidth() + " Height: " + outImg.getHeight() + " (" + Util.px2mm(outImg.getWidth(), dpi) + "x" + Util.px2mm(outImg.getHeight(), dpi) + "mm)"));
        final ActionListener list = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                lab.setText("dithering...");
                lab.repaint();
                BlackWhiteRaster.DitherAlgorithm da = (BlackWhiteRaster.DitherAlgorithm)((Object)cbDa.getSelectedItem());
                BufferedImageAdapter ad = new BufferedImageAdapter(scaledImg);
                ad.setColorShift(filter.getValue());
                BlackWhiteRaster bw = new BlackWhiteRaster((GreyscaleRaster)ad, da);
                for (int y = 0; y < bw.getHeight(); ++y) {
                    for (int x = 0; x < bw.getWidth(); ++x) {
                        outImg.setRGB(x, y, bw.isBlack(x, y) ^ cbInvert.isSelected() ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    }
                }
                Graphics2D g = buf.createGraphics();
                AffineTransform at = AffineTransform.getScaleInstance((double)buf.getWidth() / (double)bw.getWidth(), (double)buf.getWidth() / (double)bw.getWidth());
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, buf.getWidth(), buf.getHeight());
                g.drawRenderedImage(outImg, at);
                lab.setText("");
                prev.repaint();
            }
        };
        filter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                if (!filter.getValueIsAdjusting()) {
                    list.actionPerformed(null);
                }
            }
        });
        cbInvert.addActionListener(list);
        cbDa.addActionListener(list);
        cbDa.setSelectedIndex(0);
        if (JOptionPane.showConfirmDialog(null, prev, "Waehlen Sie einen Algorithmus aus", 2) == 0) {
            EpilogZing instance = new EpilogZing("137.226.56.228");
            RasterPart rp = new RasterPart(new BlackWhiteRaster((GreyscaleRaster)new BufferedImageAdapter(outImg), BlackWhiteRaster.DitherAlgorithm.AVERAGE), new PowerSpeedFocusProperty(), new Point(0, 0), dpi);
            VectorPart vp = null;
            if (cbCut.isSelected()) {
                vp = new VectorPart(new PowerSpeedFocusFrequencyProperty(), dpi);
                vp.moveto(0, 0);
                vp.lineto(outImg.getWidth(), 0);
                vp.lineto(outImg.getWidth(), outImg.getHeight());
                vp.lineto(0, outImg.getHeight());
                vp.lineto(0, 0);
            }
            LaserJob job = new LaserJob("PhotoPrint", "123", "bla");
            job.addPart(rp);
            job.addPart(vp);
            instance.sendJob(job);
            JOptionPane.showMessageDialog(null, "Please press START on the Lasercutter");
        }
    }
}

