/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.FloatPowerSpeedFocusFrequencyProperty;
import java.util.Arrays;
import java.util.LinkedList;

public class LaosCutterProperty
extends FloatPowerSpeedFocusFrequencyProperty {
    private boolean hidePurge = false;
    private boolean hideVentilation = false;
    private boolean hideFocus = false;
    private boolean hideFrequency = false;
    private boolean ventilation = true;
    private boolean purge = true;

    public LaosCutterProperty(boolean hidePurge, boolean hideVentilation, boolean hideFocus, boolean hideFrequency) {
        this.hidePurge = hidePurge;
        this.hideVentilation = hideVentilation;
        this.hideFocus = hideFocus;
        this.hideFrequency = hideFrequency;
    }

    public LaosCutterProperty() {
        this(false, false, false, false);
    }

    public boolean getVentilation() {
        return this.ventilation;
    }

    public void setVentilation(boolean ventilation) {
        this.ventilation = ventilation;
    }

    public boolean getPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    @Override
    public String[] getPropertyKeys() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(Arrays.asList(super.getPropertyKeys()));
        if (this.hideFocus) {
            result.remove("focus");
        }
        if (this.hideFrequency) {
            result.remove("frequency");
        }
        if (!this.hideVentilation) {
            result.add("ventilation");
        }
        if (!this.hidePurge) {
            result.add("purge");
        }
        return result.toArray(new String[0]);
    }

    @Override
    public Object getProperty(String name) {
        if ("ventilation".equals(name)) {
            return this.getVentilation();
        }
        if ("purge".equals(name)) {
            return this.getPurge();
        }
        return super.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("ventilation".equals(name)) {
            this.setVentilation((Boolean)value);
        } else if ("purge".equals(name)) {
            this.setPurge((Boolean)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public LaosCutterProperty clone() {
        LaosCutterProperty result = new LaosCutterProperty();
        for (String s : this.getPropertyKeys()) {
            result.setProperty(s, this.getProperty(s));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaosCutterProperty other = (LaosCutterProperty)obj;
        if (this.ventilation != other.ventilation) {
            return false;
        }
        if (this.purge != other.purge) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.ventilation ? 1 : 0);
        hash = 97 * hash + (this.purge ? 1 : 0);
        hash = 97 * hash + super.hashCode();
        return hash;
    }
}

