/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.platform.Util;

public class IModelaProperty
implements LaserProperty {
    private static String DEPTH = "milling depth (mm)";
    private static String FEED_RATE = "feed rate (mm/min)";
    private static String SPINDLE_SPEED = "spindle speed (rpm)";
    private static String TOOL = "tool";
    private static String TOOL_DIAMETER = "tool diameter (mm)";
    private double depth = 0.0;
    private double feedRate = 1.0;
    private int spindleSpeed = 100;
    private int tool = 1;
    private double toolDiameter = 4.0;

    public double getToolDiameter() {
        return this.toolDiameter;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getFeedRate() {
        return this.feedRate;
    }

    public int getSpindleSpeed() {
        return this.spindleSpeed;
    }

    public int getTool() {
        return this.tool;
    }

    @Override
    public Object getMinimumValue(String name) {
        if (TOOL.equals(name)) {
            return 1;
        }
        if (SPINDLE_SPEED.equals(name)) {
            return 100;
        }
        return 0.0;
    }

    @Override
    public Object getMaximumValue(String name) {
        return null;
    }

    @Override
    public Object[] getPossibleValues(String name) {
        return null;
    }

    @Override
    public LaserProperty clone() {
        IModelaProperty result = new IModelaProperty();
        for (String k : this.getPropertyKeys()) {
            result.setProperty(k, this.getProperty(k));
        }
        return result;
    }

    @Override
    public String[] getPropertyKeys() {
        return new String[]{DEPTH, SPINDLE_SPEED, FEED_RATE, TOOL, TOOL_DIAMETER};
    }

    @Override
    public void setProperty(String key, Object value) {
        if (DEPTH.equals(key)) {
            this.depth = (Double)value;
        } else if (SPINDLE_SPEED.equals(key)) {
            this.spindleSpeed = (Integer)value;
        } else if (FEED_RATE.equals(key)) {
            this.feedRate = (Double)value;
        } else if (TOOL.equals(key)) {
            this.tool = (Integer)value;
        } else if (TOOL_DIAMETER.equals(key)) {
            this.toolDiameter = (Double)value;
        }
    }

    @Override
    public Object getProperty(String key) {
        if (DEPTH.equals(key)) {
            return this.depth;
        }
        if (SPINDLE_SPEED.equals(key)) {
            return this.spindleSpeed;
        }
        if (FEED_RATE.equals(key)) {
            return this.feedRate;
        }
        if (TOOL.equals(key)) {
            return this.tool;
        }
        if (TOOL_DIAMETER.equals(key)) {
            return this.toolDiameter;
        }
        return null;
    }

    public int hashCode() {
        int hash = 13;
        for (String k : this.getPropertyKeys()) {
            if (this.getProperty(k) == null) continue;
            hash = 97 * hash + k.hashCode() + this.getProperty(k).hashCode();
        }
        return hash += super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IModelaProperty other = (IModelaProperty)obj;
        for (String k : this.getPropertyKeys()) {
            if (!Util.differ(this.getProperty(k), other.getProperty(k))) continue;
            return false;
        }
        return true;
    }
}

