/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserCutter;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.drivers.IModelaProperty;
import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.platform.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IModelaMill
extends LaserCutter {
    private static String HOSTNAME = "Hostname/IP";
    private static String PORT = "port";
    private static String BED_WIDTH = "bed width";
    private static String BED_HEIGHT = "bed height";
    private static String FLIP_YAXIS = "flip y axis";
    private static String HOME_ON_END = "move home after job";
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private boolean spindleOn = false;
    private double movedepth = 0.0;
    private double linedepth = 0.0;
    private double headdepth = 0.0;
    private double spindleSpeed = 0.0;
    private double feedRate = 0.0;
    private int tool = 0;
    private String parameters = "";

    public IModelaMill() {
        this.properties.put(BED_WIDTH, 85.0);
        this.properties.put(BED_HEIGHT, 55.0);
        this.properties.put(HOSTNAME, "file:///dev/usb/lp0");
        this.properties.put(PORT, 5000);
        this.properties.put(HOME_ON_END, true);
        this.properties.put(FLIP_YAXIS, false);
    }

    private void setSpindleOn(PrintStream out, boolean spindleOn) {
        if (spindleOn != this.spindleOn) {
            this.spindleOn = spindleOn;
            out.println(spindleOn ? "M03" : "M05");
        }
    }

    private void writeInitializationCode(PrintStream out) {
        out.println("%");
        out.println("O00000001");
        out.println("G90");
        out.println("G21");
    }

    private void writeFinalizationCode(PrintStream out) {
        this.setSpindleOn(out, false);
        out.println("G0 Z0");
        if (((Boolean)this.properties.get(HOME_ON_END)).booleanValue()) {
            out.println("G0 X0 Y0");
        }
        out.println("M02");
        out.println("%");
    }

    private void moveHead(PrintStream out, double depth) {
        if (this.headdepth > depth) {
            out.println(String.format(Locale.ENGLISH, "G00 Z%f%s\n", -depth, this.parameters));
            this.parameters = "";
        } else if (this.headdepth < depth) {
            out.println(String.format(Locale.ENGLISH, "G01 Z%f%s\n", -depth, this.parameters));
            this.parameters = "";
        }
        this.headdepth = depth;
    }

    private void move(PrintStream out, double x, double y) {
        this.moveHead(out, this.movedepth);
        out.print(String.format(Locale.ENGLISH, "G00 X%f Y%f%s\n", x, this.properties.get(FLIP_YAXIS) == Boolean.TRUE ? this.getBedHeight() - y : y, this.parameters));
        this.parameters = "";
    }

    private void line(PrintStream out, double x, double y) {
        this.setSpindleOn(out, true);
        this.moveHead(out, this.linedepth);
        out.print(String.format(Locale.ENGLISH, "G01 X%f Y%f%s\n", x, this.properties.get(FLIP_YAXIS) == Boolean.TRUE ? this.getBedHeight() - y : y, this.parameters));
        this.parameters = "";
    }

    private void applyProperty(PrintStream out, IModelaProperty pr) {
        this.linedepth = pr.getDepth();
        if ((double)pr.getSpindleSpeed() != this.spindleSpeed) {
            this.spindleSpeed = pr.getSpindleSpeed();
            this.parameters = this.parameters + String.format(Locale.ENGLISH, " S%f\n", this.spindleSpeed);
        }
        if (pr.getFeedRate() != this.feedRate) {
            this.feedRate = pr.getFeedRate();
            this.parameters = this.parameters + String.format(Locale.ENGLISH, " F%f\n", this.feedRate);
        }
        if (pr.getTool() != this.tool) {
            this.tool = pr.getTool();
            out.print(String.format(Locale.ENGLISH, "M06T0\n", new Object[0]));
            out.print(String.format(Locale.ENGLISH, "M06T%d\n", this.tool));
        }
    }

    private double getBlackPercent(RasterPart p, int cx, int cy, int toolDiameter) {
        double count = toolDiameter * toolDiameter;
        double black = 0.0;
        for (int x = Math.max(cx - toolDiameter / 2, 0); x < Math.min(cx + toolDiameter / 2, p.getRasterWidth()); ++x) {
            for (int y = Math.max(cy - toolDiameter / 2, 0); y < Math.min(cy + toolDiameter / 2, p.getRasterHeight()); ++y) {
                if (!p.isBlack(x, y)) continue;
                black += 1.0;
            }
        }
        return black / count;
    }

    private double getAverageGrey(Raster3dPart p, int cx, int cy, int toolDiameter) {
        double count = toolDiameter * toolDiameter;
        double value = 0.0;
        for (int y = Math.max(cy - toolDiameter / 2, 0); y < Math.min(cy + toolDiameter / 2, p.getRasterHeight()); ++y) {
            List<Byte> line = p.getRasterLine(y);
            for (int x = Math.max(cx - toolDiameter / 2, 0); x < Math.min(cx + toolDiameter / 2, p.getRasterWidth()); ++x) {
                value += (double)line.get(x).byteValue();
            }
        }
        return value / count / 255.0;
    }

    private void writeRasterCode(RasterPart p, PrintStream out) {
        double dpi = p.getDPI();
        double treshold = 0.7;
        IModelaProperty prop = (IModelaProperty)p.getLaserProperty();
        int toolDiameterInPx = (int)Util.mm2px(prop.getToolDiameter(), dpi);
        this.applyProperty(out, prop);
        boolean leftToRight = true;
        Point offset = p.getRasterStart();
        this.move(out, Util.px2mm(offset.x, dpi), Util.px2mm(offset.y, dpi));
        for (int y = 0; y < p.getRasterHeight(); y += toolDiameterInPx / 2) {
            int x;
            int n = x = leftToRight ? 0 : p.getRasterWidth() - 1;
            while (leftToRight && x < p.getRasterWidth() || !leftToRight && x >= 0) {
                if (this.getBlackPercent(p, x, y, toolDiameterInPx) < treshold) {
                    while (true) {
                        if (!leftToRight || x + 1 >= p.getRasterWidth()) {
                            if (leftToRight || x - 1 < 0) break;
                            int n2 = leftToRight ? x + 1 : x - 1;
                            if (!(this.getBlackPercent(p, n2, y, toolDiameterInPx) < treshold)) break;
                        }
                        x += leftToRight ? 1 : -1;
                    }
                    this.move(out, Util.px2mm(offset.x + x, dpi), Util.px2mm(offset.y + y, dpi));
                } else {
                    while (true) {
                        if (!leftToRight || x + 1 >= p.getRasterWidth()) {
                            if (leftToRight || x - 1 < 0) break;
                            int n3 = leftToRight ? x + 1 : x - 1;
                            if (!(this.getBlackPercent(p, n3, y, toolDiameterInPx) >= treshold)) break;
                        }
                        x += leftToRight ? 1 : -1;
                    }
                    this.line(out, Util.px2mm(offset.x + x, dpi), Util.px2mm(offset.y + y, dpi));
                }
                x += leftToRight ? 1 : -1;
            }
            leftToRight = !leftToRight;
        }
    }

    private void writeRaster3dCode(Raster3dPart p, PrintStream out) {
        double dpi = p.getDPI();
        IModelaProperty prop = (IModelaProperty)p.getLaserProperty();
        int toolDiameterInPx = (int)Util.mm2px(prop.getToolDiameter(), dpi);
        this.applyProperty(out, prop);
        boolean leftToRight = true;
        Point offset = p.getRasterStart();
        this.move(out, Util.px2mm(offset.x, dpi), Util.px2mm(offset.y, dpi));
        for (int y = 0; y < p.getRasterHeight(); y += toolDiameterInPx / 2) {
            int x;
            int n = x = leftToRight ? 0 : p.getRasterWidth() - 1;
            while (leftToRight && x < p.getRasterWidth() || !leftToRight && x >= 0) {
                this.linedepth = this.getAverageGrey(p, x, y, toolDiameterInPx) * prop.getDepth();
                while (leftToRight && x + 1 < p.getRasterWidth() || !leftToRight && x - 1 >= 0 && this.getAverageGrey(p, leftToRight ? x + 1 : x - 1, y, toolDiameterInPx) == this.linedepth) {
                    x += leftToRight ? 1 : -1;
                }
                this.line(out, Util.px2mm(offset.x + x, dpi), Util.px2mm(offset.y + y, dpi));
                x += leftToRight ? 1 : -1;
            }
            leftToRight = !leftToRight;
        }
    }

    private void writeVectorCode(VectorPart p, PrintStream out) {
        double dpi = p.getDPI();
        block5: for (VectorCommand c : p.getCommandList()) {
            switch (c.getType()) {
                case MOVETO: {
                    double x = Util.px2mm(c.getX(), dpi);
                    double y = this.getBedHeight() - Util.px2mm(c.getY(), dpi);
                    this.move(out, x, y);
                    continue block5;
                }
                case LINETO: {
                    double x = Util.px2mm(c.getX(), dpi);
                    double y = this.getBedHeight() - Util.px2mm(c.getY(), dpi);
                    this.line(out, x, y);
                    continue block5;
                }
                case SETPROPERTY: {
                    IModelaProperty pr = (IModelaProperty)c.getProperty();
                    this.applyProperty(out, pr);
                    continue block5;
                }
            }
        }
    }

    @Override
    public LaserProperty getLaserPropertyForRaster3dPart() {
        return new IModelaProperty();
    }

    @Override
    public LaserProperty getLaserPropertyForVectorPart() {
        return new IModelaProperty();
    }

    @Override
    public LaserProperty getLaserPropertyForRasterPart() {
        return new IModelaProperty();
    }

    @Override
    public void sendJob(LaserJob job, ProgressListener pl, List<String> warnings) throws IllegalJobException, Exception {
        pl.taskChanged(this, "checking...");
        this.checkJob(job);
        pl.progressChanged(this, 20);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        pl.taskChanged(this, "generating...");
        this.writeInitializationCode(out);
        double all = job.getParts().size();
        int i = 1;
        for (JobPart p : job.getParts()) {
            if (p instanceof VectorPart) {
                this.writeVectorCode((VectorPart)p, out);
            } else if (p instanceof RasterPart) {
                this.writeRasterCode((RasterPart)p, out);
            } else if (p instanceof Raster3dPart) {
                this.writeRaster3dCode((Raster3dPart)p, out);
            }
            pl.progressChanged(this, (int)(20.0 + (double)(30 * i++) / all));
        }
        this.writeFinalizationCode(out);
        pl.progressChanged(this, 50);
        pl.taskChanged(this, "sending...");
        this.sendGCode(result.toByteArray(), pl, warnings);
        pl.progressChanged(this, 100);
        pl.taskChanged(this, "done");
    }

    @Override
    public List<Double> getResolutions() {
        return Arrays.asList(100.0, 200.0, 300.0, 400.0, 500.0, 1000.0, 1200.0, Util.dpmm2dpi(1000.0));
    }

    @Override
    public double getBedWidth() {
        if (this.properties.get(BED_WIDTH) == null) {
            this.properties.put(BED_WIDTH, 85.0);
        }
        return (Double)this.properties.get(BED_WIDTH);
    }

    @Override
    public double getBedHeight() {
        if (this.properties.get(BED_HEIGHT) == null) {
            this.properties.put(BED_HEIGHT, 55.0);
        }
        return (Double)this.properties.get(BED_HEIGHT);
    }

    @Override
    public String getModelName() {
        return "ROLAND iModela";
    }

    @Override
    public LaserCutter clone() {
        IModelaMill result = new IModelaMill();
        for (String k : this.getPropertyKeys()) {
            result.setProperty(k, this.getProperty(k));
        }
        return result;
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[0]);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    private void sendGCode(byte[] gcode, ProgressListener pl, List<String> warnings) throws IOException, URISyntaxException {
        String hostname = (String)this.properties.get(HOSTNAME);
        pl.taskChanged(this, "connecting...");
        if ("stdout".equals(hostname)) {
            pl.taskChanged(this, "sending...");
            System.out.write(gcode);
        } else if (hostname.startsWith("file://")) {
            PrintStream w = new PrintStream(new FileOutputStream(new File(new URI(hostname))));
            pl.taskChanged(this, "sending...");
            w.write(gcode);
            w.close();
        } else if (hostname.startsWith("printer://")) {
            String printername = hostname.substring(10);
            try {
                File tempFile = File.createTempFile(printername, ".txt");
                PrintStream w = new PrintStream(new FileOutputStream(tempFile));
                pl.taskChanged(this, "sending...");
                w.write(gcode);
                System.out.println("tempFile: " + tempFile.getAbsolutePath());
                Runtime.getRuntime().exec("/usr/bin/lp -d " + printername + " " + tempFile.getAbsolutePath());
            }
            catch (IOException ex) {
                System.err.println("Cannot create temp file: " + ex.getMessage());
            }
        } else {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(hostname, (int)((Integer)this.properties.get(PORT))), 3000);
            pl.taskChanged(this, "sending...");
            s.getOutputStream().write(gcode);
            s.close();
        }
    }
}

