/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserCutter;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.PowerSpeedFocusProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class Dummy
extends LaserCutter {
    private static final String SETTING_BEDWIDTH = "Laserbed width";
    private static final String SETTING_BEDHEIGHT = "Laserbed height";
    private static final String SETTING_RUNTIME = "Fake estimated run-time in seconds (-1 to disable)";
    private static final String SETTING_SVG_OUTDIR = "SVG Debug output directory (set empty to disable)";
    private List<Double> resolutions;
    protected int fakeRunTime = -1;
    protected double bedWidth = 250.0;
    protected double bedHeight = 280.0;
    public String svgOutdir = "";
    private static String[] settingAttributes = new String[]{"Laserbed width", "Laserbed height", "Fake estimated run-time in seconds (-1 to disable)", "SVG Debug output directory (set empty to disable)"};

    @Override
    public String getModelName() {
        return "Dummy";
    }

    @Override
    public void sendJob(LaserJob job, ProgressListener pl, List<String> warnings) throws IllegalJobException, Exception {
        pl.progressChanged(this, 0);
        pl.taskChanged(this, "checking job");
        this.checkJob(job);
        job.applyStartPoint();
        pl.taskChanged(this, "sending");
        pl.taskChanged(this, "sent.");
        SVGWriter svg = new SVGWriter(this);
        System.out.println("dummy-driver got LaserJob: ");
        for (JobPart p : job.getParts()) {
            JobPart rp;
            svg.startPart(p.getClass().getSimpleName(), p.getDPI());
            if (p instanceof VectorPart) {
                System.out.println("VectorPart");
                for (VectorCommand cmd : ((VectorPart)p).getCommandList()) {
                    if (cmd.getType() == VectorCommand.CmdType.SETPROPERTY) {
                        if (!(cmd.getProperty() instanceof PowerSpeedFocusFrequencyProperty)) {
                            throw new IllegalJobException("This driver expects Power,Speed,Frequency and Focus as settings");
                        }
                        System.out.println(((PowerSpeedFocusFrequencyProperty)cmd.getProperty()).toString());
                        continue;
                    }
                    if (cmd.getType() == VectorCommand.CmdType.LINETO) {
                        System.out.println("LINETO \t" + cmd.getX() + ", \t" + cmd.getY());
                        svg.lineTo(cmd.getX(), cmd.getY());
                        continue;
                    }
                    if (cmd.getType() != VectorCommand.CmdType.MOVETO) continue;
                    System.out.println("MOVETO \t" + cmd.getX() + ", \t" + cmd.getY());
                    svg.moveTo(cmd.getX(), cmd.getY());
                }
            }
            if (p instanceof RasterPart) {
                System.out.println("RasterPart");
                rp = (RasterPart)p;
                if (((RasterPart)rp).getLaserProperty() != null && !(((RasterPart)rp).getLaserProperty() instanceof PowerSpeedFocusProperty)) {
                    throw new IllegalJobException("This driver expects Power,Speed and Focus as settings");
                }
                System.out.println(((PowerSpeedFocusProperty)((RasterPart)rp).getLaserProperty()).toString());
            }
            if (!(p instanceof Raster3dPart)) continue;
            System.out.println("Raster3dPart");
            rp = (Raster3dPart)p;
            if (((Raster3dPart)rp).getLaserProperty() != null && !(((Raster3dPart)rp).getLaserProperty() instanceof PowerSpeedFocusProperty)) {
                throw new IllegalJobException("This driver expects Power,Speed and Focus as settings");
            }
            System.out.println(((PowerSpeedFocusProperty)((Raster3dPart)rp).getLaserProperty()).toString());
        }
        System.out.println("end of job.");
        svg.store(this.svgOutdir);
        pl.progressChanged(this, 100);
    }

    @Override
    public int estimateJobDuration(LaserJob job) {
        if (!this.canEstimateJobDuration()) {
            throw new RuntimeException("cannot estimate job duration (dummy driver: fake runtime is set to negative value)");
        }
        return this.fakeRunTime;
    }

    @Override
    public boolean canEstimateJobDuration() {
        return this.fakeRunTime >= 0;
    }

    @Override
    public List<Double> getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = Arrays.asList(500.0);
        }
        return this.resolutions;
    }

    @Override
    public double getBedWidth() {
        return this.bedWidth;
    }

    public void setBedWidth(double bedWidth) {
        this.bedWidth = bedWidth;
    }

    @Override
    public double getBedHeight() {
        return this.bedHeight;
    }

    public void setBedHeight(double bedHeight) {
        this.bedHeight = bedHeight;
    }

    @Override
    public String[] getPropertyKeys() {
        return settingAttributes;
    }

    @Override
    public Object getProperty(String attribute) {
        if (SETTING_BEDWIDTH.equals(attribute)) {
            return this.getBedWidth();
        }
        if (SETTING_BEDHEIGHT.equals(attribute)) {
            return this.getBedHeight();
        }
        if (SETTING_RUNTIME.equals(attribute)) {
            return this.fakeRunTime;
        }
        if (SETTING_SVG_OUTDIR.equals(attribute)) {
            return this.svgOutdir;
        }
        return null;
    }

    @Override
    public void setProperty(String attribute, Object value) {
        if (SETTING_BEDWIDTH.equals(attribute)) {
            this.setBedWidth((Double)value);
        } else if (SETTING_BEDHEIGHT.equals(attribute)) {
            this.setBedHeight((Double)value);
        } else if (SETTING_RUNTIME.equals(attribute)) {
            this.fakeRunTime = Integer.parseInt(value.toString());
        } else if (SETTING_SVG_OUTDIR.equals(attribute)) {
            this.svgOutdir = value.toString();
        }
    }

    @Override
    public LaserCutter clone() {
        Dummy clone = new Dummy();
        clone.bedHeight = this.bedHeight;
        clone.bedWidth = this.bedWidth;
        clone.fakeRunTime = this.fakeRunTime;
        return clone;
    }

    class SVGWriter {
        private double xPrev;
        private double xNow;
        private double yPrev;
        private double yNow;
        private StringBuilder svg = new StringBuilder();
        private boolean vectorPathActive = false;
        private boolean partActive = false;
        private int idCounter = 0;
        private int partCounter = 0;
        private LaserCutter cutter;
        private double dpi;

        public SVGWriter(LaserCutter cutter) {
            this.cutter = cutter;
        }

        public void startPart(String title, double dpi) {
            this.endPart();
            ++this.partCounter;
            this.dpi = dpi;
            this.partActive = true;
            this.svg.append("<g style=\"fill:none;stroke:#000000;stroke-width:0.1mm;\" id=\"");
            this.svg.append("visicut-part").append(this.partCounter).append("-");
            this.svg.append(title.replaceAll("[^a-zA-Z0-9]", "_"));
            this.svg.append("\">\n");
        }

        public void endPart() {
            this.moveTo(0, 0);
            if (this.partActive) {
                this.partActive = false;
                this.svg.append("</g>\n");
            }
        }

        private void setLocation(int x, int y) {
            this.xPrev = this.xNow;
            this.yPrev = this.yNow;
            double factor = 25.4 / this.dpi;
            this.xNow = (double)x * factor;
            this.yNow = (double)y * factor;
        }

        void moveTo(int x, int y) {
            this.setLocation(x, y);
            if (this.vectorPathActive) {
                this.svg.append("\"/>\n");
                this.vectorPathActive = false;
            }
        }

        void lineTo(int x, int y) {
            this.setLocation(x, y);
            if (!this.partActive) {
                throw new RuntimeException("lineTo called outside of a part!");
            }
            if (!this.vectorPathActive) {
                this.vectorPathActive = true;
                this.svg.append("<path id=\"visicut-").append(this.idCounter).append("\" d=\"M ");
                ++this.idCounter;
                this.svg.append(this.xPrev).append(",").append(this.yPrev).append(" ");
            }
            this.svg.append(this.xNow).append(",").append(this.yNow).append(" ");
        }

        private String getSVG() {
            this.endPart();
            this.svg.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> \n<!-- Created by VisiCut Debug output -->\n<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" width=\"" + this.cutter.getBedWidth() + "mm\" " + "height=\"" + this.cutter.getBedHeight() + "mm\" " + "viewBox=\"0 0 " + this.cutter.getBedWidth() + " " + this.cutter.getBedHeight() + "\" " + "version=\"1.1\" id=\"svg\"> \n");
            this.svg.append("</svg>\n");
            String result = this.svg.toString();
            this.svg = new StringBuilder();
            this.idCounter = 0;
            return result;
        }

        private void storeString(String path, String str) {
            try {
                FileWriter f = new FileWriter(path);
                BufferedWriter b = new BufferedWriter(f);
                b.write(str);
                b.close();
            }
            catch (Exception e) {
                System.out.println("Could not write debug SVG: Exception: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeXHTML(String path, String svgString) {
            BufferedReader br = null;
            StringBuilder xhtml = new StringBuilder();
            try {
                InputStream stream = new Dummy().getClass().getResourceAsStream("resources/visicut-svg-output-viewer.xhtml");
                StringBuilder s = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.contains("<!-- REPLACE THIS WITH SVG -->")) {
                        line = svgString.substring(svgString.indexOf("\n"));
                    }
                    xhtml.append(line).append("\n");
                }
                this.storeString(path, xhtml.toString());
            }
            catch (Exception e) {
                System.out.println("could not store debug XHTML: " + e);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    System.out.println("could not close bufferedWriter when storing debug XHTML");
                }
            }
        }

        void store(String directory) {
            if (directory == null || directory.isEmpty()) {
                System.out.println("Not writing debug SVG - no output directory set (edit lasercutter settings to change)");
            } else {
                String pathSVG = directory + "/visicut-debug.svg";
                System.out.println("storing SVG debug output to " + pathSVG);
                String svgString = this.getSVG();
                this.storeString(pathSVG, svgString);
                String pathXHTML = directory + "/visicut-svg-output-viewer.xhtml";
                System.out.println("storing SVG debug output (XHTML viewer) to " + pathXHTML);
                this.storeXHTML(pathXHTML, svgString);
            }
        }
    }
}

