/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.dithering;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.dithering.DitheringAlgorithm;

public class Average
extends DitheringAlgorithm {
    @Override
    protected void doDithering(GreyscaleRaster src, BlackWhiteRaster target) {
        long lumTotal = 0L;
        int pixelcount = 0;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                lumTotal += (long)src.getGreyScale(x, y);
            }
            this.setProgress(100 * pixelcount++ / (2 * height));
        }
        int thresh = (int)(lumTotal / (long)height / (long)width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.setBlack(src, target, x, y, src.getGreyScale(x, y) < thresh);
            }
            this.setProgress(100 * pixelcount++ / (2 * height));
        }
    }

    @Override
    public DitheringAlgorithm clone() {
        return new Average();
    }

    @Override
    public String toString() {
        return "Average Dithering";
    }
}

