/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.VectorCommand;
import java.util.LinkedList;
import java.util.List;

public class VectorPart
extends JobPart {
    private LaserProperty currentCuttingProperty;
    private int maxX;
    private int maxY;
    private int minX;
    private int minY;
    private double resolution = 500.0;
    private List<VectorCommand> commands;

    public VectorPart(LaserProperty initialProperty, double resolution) {
        if (initialProperty == null) {
            throw new IllegalArgumentException("Initial Property must not be null");
        }
        this.resolution = resolution;
        this.commands = new LinkedList<VectorCommand>();
        this.currentCuttingProperty = initialProperty;
        this.commands.add(new VectorCommand(VectorCommand.CmdType.SETPROPERTY, initialProperty));
    }

    @Override
    public double getDPI() {
        return this.resolution;
    }

    public LaserProperty getCurrentCuttingProperty() {
        return this.currentCuttingProperty;
    }

    public void setProperty(LaserProperty cp) {
        this.currentCuttingProperty = cp;
        this.commands.add(new VectorCommand(VectorCommand.CmdType.SETPROPERTY, cp));
    }

    public VectorCommand[] getCommandList() {
        return this.commands.toArray(new VectorCommand[0]);
    }

    private void checkMin(int x, int y) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
    }

    private void checkMax(int x, int y) {
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public void moveto(int x, int y) {
        this.commands.add(new VectorCommand(VectorCommand.CmdType.MOVETO, x, y));
        this.checkMin(x, y);
        this.checkMax(x, y);
    }

    public void lineto(int x, int y) {
        this.commands.add(new VectorCommand(VectorCommand.CmdType.LINETO, x, y));
        this.checkMin(x, y);
        this.checkMax(x, y);
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }
}

