/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.LaserProperty;

public class VectorCommand {
    private CmdType type;
    private int[] operands;
    private float foperand;
    private LaserProperty property;

    void setX(int d) {
        if (this.type != CmdType.MOVETO && this.type != CmdType.LINETO) {
            throw new UnsupportedOperationException("setX not supported for " + this.type.toString());
        }
        this.operands[0] = d;
    }

    void setY(int d) {
        if (this.type != CmdType.MOVETO && this.type != CmdType.LINETO) {
            throw new UnsupportedOperationException("setY not supported for " + this.type.toString());
        }
        this.operands[1] = d;
    }

    public VectorCommand(CmdType type, int x, int y) {
        if (type != CmdType.MOVETO && type != CmdType.LINETO) {
            throw new IllegalArgumentException("Wrong number of Parameters for " + type.toString());
        }
        this.type = type;
        this.operands = new int[]{x, y};
    }

    public VectorCommand(CmdType type, LaserProperty p) {
        if (type != CmdType.SETPROPERTY) {
            throw new IllegalArgumentException("Only valid for SETPROPERTY");
        }
        this.type = type;
        this.property = p;
    }

    public CmdType getType() {
        return this.type;
    }

    public int getX() {
        if (this.type == CmdType.MOVETO || this.type == CmdType.LINETO) {
            return this.operands[0];
        }
        throw new UnsupportedOperationException("getX not supported for " + this.type.toString());
    }

    public int getY() {
        if (this.type == CmdType.MOVETO || this.type == CmdType.LINETO) {
            return this.operands[1];
        }
        throw new UnsupportedOperationException("getX not supported for " + this.type.toString());
    }

    public LaserProperty getProperty() {
        if (this.type == CmdType.SETPROPERTY) {
            return this.property;
        }
        throw new UnsupportedOperationException("Only valid for PROPERTY");
    }

    public static enum CmdType {
        SETPROPERTY,
        MOVETO,
        LINETO;

    }
}

