/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.platform.Point;
import java.util.LinkedList;
import java.util.List;

public class Raster3dPart
extends JobPart {
    private GreyscaleRaster image = null;
    private LaserProperty property = null;
    protected Point start = null;
    private double resolution = 500.0;

    public Raster3dPart(GreyscaleRaster image, LaserProperty laserProperty, Point offset, double resolution) {
        this.image = image;
        this.resolution = resolution;
        this.property = laserProperty;
        this.start = offset;
    }

    @Override
    public double getDPI() {
        return this.resolution;
    }

    @Override
    public int getMinX() {
        return this.start.x;
    }

    @Override
    public int getMaxX() {
        return this.start.x + this.image.getWidth();
    }

    @Override
    public int getMinY() {
        return this.start.y;
    }

    @Override
    public int getMaxY() {
        return this.start.y + this.image.getHeight();
    }

    public Point getRasterStart() {
        return this.start;
    }

    public List<Byte> getRasterLine(int line) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        for (int x = 0; x < this.image.getWidth(); ++x) {
            result.add((byte)this.image.getGreyScale(x, line));
        }
        return result;
    }

    public int getRasterWidth() {
        return this.image.getWidth();
    }

    public int getRasterHeight() {
        return this.image.getHeight();
    }

    public LaserProperty getLaserProperty() {
        return this.property;
    }

    public List<Byte> getInvertedRasterLine(int line) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        for (int x = 0; x < this.image.getWidth(); ++x) {
            result.add((byte)(255 - this.image.getGreyScale(x, line)));
        }
        return result;
    }
}

