/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.LaserProperty;

public class PowerSpeedFocusProperty
implements LaserProperty {
    private int power = 20;
    private int speed = 100;
    private float focus = 0.0f;
    private static String[] propertyNames = new String[]{"power", "speed", "focus"};

    public void setPower(int power) {
        power = power < 0 ? 0 : power;
        this.power = power = power > 100 ? 100 : power;
    }

    public int getPower() {
        return this.power;
    }

    public void setSpeed(int speed) {
        speed = speed < 0 ? 0 : speed;
        this.speed = speed = speed > 100 ? 100 : speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setFocus(float focus) {
        this.focus = focus;
    }

    public float getFocus() {
        return this.focus;
    }

    @Override
    public PowerSpeedFocusProperty clone() {
        PowerSpeedFocusProperty p = new PowerSpeedFocusProperty();
        p.power = this.power;
        p.speed = this.speed;
        p.focus = this.focus;
        return p;
    }

    @Override
    public String[] getPropertyKeys() {
        return propertyNames;
    }

    @Override
    public Object getProperty(String name) {
        if ("power".equals(name)) {
            return this.getPower();
        }
        if ("speed".equals(name)) {
            return this.getSpeed();
        }
        if ("focus".equals(name)) {
            return Float.valueOf(this.getFocus());
        }
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("power".equals(name)) {
            this.setPower((Integer)value);
        } else if ("speed".equals(name)) {
            this.setSpeed((Integer)value);
        } else if ("focus".equals(name)) {
            this.setFocus(((Float)value).floatValue());
        } else {
            throw new IllegalArgumentException("Unknown setting '" + name + "'");
        }
    }

    @Override
    public Object getMinimumValue(String name) {
        if ("power".equals(name)) {
            return 0;
        }
        if ("speed".equals(name)) {
            return 0;
        }
        if ("focus".equals(name)) {
            return null;
        }
        throw new IllegalArgumentException("Unknown setting '" + name + "'");
    }

    @Override
    public Object getMaximumValue(String name) {
        if ("power".equals(name)) {
            return 100;
        }
        if ("speed".equals(name)) {
            return 100;
        }
        if ("focus".equals(name)) {
            return null;
        }
        throw new IllegalArgumentException("Unknown setting '" + name + "'");
    }

    @Override
    public Object[] getPossibleValues(String name) {
        return null;
    }

    public String toString() {
        return "PowerSpeedFocusFrequencyProperty(power=" + this.getPower() + ",speed=" + this.getSpeed() + ",focus=" + this.getFocus() + ")";
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + this.power;
        hash = 71 * hash + this.speed;
        hash = 71 * hash + Float.floatToIntBits(this.focus);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PowerSpeedFocusProperty other = (PowerSpeedFocusProperty)obj;
        if (this.power != other.power) {
            return false;
        }
        if (this.speed != other.speed) {
            return false;
        }
        return Float.floatToIntBits(this.focus) == Float.floatToIntBits(other.focus);
    }
}

