/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut;

import com.t_oster.liblasercut.Customizable;
import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.PowerSpeedFocusProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.platform.Util;
import java.util.LinkedList;
import java.util.List;

public abstract class LaserCutter
implements Cloneable,
Customizable {
    protected void checkJob(LaserJob job) throws IllegalJobException {
        for (JobPart p : job.getParts()) {
            boolean pass = false;
            for (double d : this.getResolutions()) {
                if (d != p.getDPI()) continue;
                pass = true;
                break;
            }
            if (!pass) {
                throw new IllegalJobException("Resoluiton of " + p.getDPI() + " is not supported");
            }
            if (p.getMinX() < 0 || p.getMinY() < 0) {
                throw new IllegalJobException("The Job exceeds the laser-bed on the top or left edge");
            }
            double maxX = Util.px2mm(p.getMaxX(), p.getDPI());
            double maxY = Util.px2mm(p.getMaxY(), p.getDPI());
            if (!(maxX > this.getBedWidth()) && !(maxY > this.getBedHeight())) continue;
            throw new IllegalJobException("The Job is too big (" + maxX + "x" + maxY + ") for the Laser bed (" + this.getBedWidth() + "x" + this.getBedHeight() + ")");
        }
    }

    public void sendJob(LaserJob job, ProgressListener pl) throws IllegalJobException, Exception {
        this.sendJob(job, pl, new LinkedList<String>());
    }

    public abstract void sendJob(LaserJob var1, ProgressListener var2, List<String> var3) throws IllegalJobException, Exception;

    public boolean isAutoFocus() {
        return false;
    }

    public void sendJob(LaserJob job, List<String> warnings) throws IllegalJobException, Exception {
        this.sendJob(job, new ProgressListener(){

            @Override
            public void progressChanged(Object source, int percent) {
                System.out.println("" + percent + "%");
            }

            @Override
            public void taskChanged(Object source, String taskName) {
                System.out.println(taskName + "...");
            }
        }, warnings);
    }

    public void sendJob(LaserJob job) throws IllegalJobException, Exception {
        LinkedList<String> warnings = new LinkedList<String>();
        this.sendJob(job, warnings);
        for (String w : warnings) {
            System.out.println("WARNING: " + w);
        }
    }

    public abstract List<Double> getResolutions();

    public abstract double getBedWidth();

    public abstract double getBedHeight();

    public boolean canEstimateJobDuration() {
        return false;
    }

    public int estimateJobDuration(LaserJob job) {
        throw new RuntimeException("Method not implemented");
    }

    public LaserProperty getLaserPropertyForVectorPart() {
        return new PowerSpeedFocusFrequencyProperty();
    }

    public LaserProperty getLaserPropertyForRasterPart() {
        return new PowerSpeedFocusProperty();
    }

    public LaserProperty getLaserPropertyForRaster3dPart() {
        return new PowerSpeedFocusProperty();
    }

    public abstract String getModelName();

    public abstract LaserCutter clone();
}

