//
//  ViewController.m
//  Lab4Demo
//
//  Created by chat on 18.11.13.
//  Copyright (c) 2013 chat. All rights reserved.
//

#import "ViewController.h"
#import "ImageManager.h"

@interface ViewController ()

@property ImageManager *imageManager;
@property (weak, nonatomic) IBOutlet UIImageView *imageView;
@property NSInteger imageIndex;

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	
    self.imageManager = [[ImageManager alloc] init];
    self.imageIndex = -1;
    [self updateImageWithIndex:0];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    
    NSLog(@"Received memory warning");
    
}


#define TAG_BACK 1
#define TAG_NEXT 2

- (IBAction)onClickNavigation:(id)sender;
{
    NSInteger index = self.imageIndex;
    
    switch (((UIButton *)sender).tag)
    {
        case TAG_BACK:
        {
            index = MAX(index - 1, 0);
            break;
        }
        case TAG_NEXT:
        {
            index = MIN(index + 1, [self.imageManager imageCount] - 1);
            break;
        }
        default:
            break;
    }
    
    [self updateImageWithIndex:index];
    

}

- (void)updateImageWithIndex:(NSInteger)theIndex;
{
    if (theIndex != self.imageIndex)
    {
        self.imageView.image = [self.imageManager imageForIndex:theIndex];
        self.imageIndex = theIndex;
    }
}

@end
