//
//  ImageManager.m
//  Lab4Demo
//
//  Created by chat on 18.11.13.
//  Copyright (c) 2013 chat. All rights reserved.
//

#import "ImageManager.h"

@interface ImageManager ()

@property NSString *fullResImagePath;
@property NSString *lowResImagePath;
@property NSArray *images;
@property NSArray *imageFileNames;

@property NSMutableArray *imageDataArray;

@end

@implementation ImageManager


- (id)init
{
    self = [super init];
    if (self)
    {
        self.imageFileNames = [NSArray arrayWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"Images" ofType:@"plist"]];
        self.fullResImagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:@"Images"];
        self.lowResImagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:@"Images-lowRes"];

        // Method 1: basic implementation
        NSMutableArray *tempImages = [[NSMutableArray alloc] init];
        for (NSInteger i = 0; i < [self.imageFileNames count]; i++)
        {
            NSString *fileName =  [self.imageFileNames objectAtIndex:i];
            NSString *imagePath = [self.fullResImagePath stringByAppendingPathComponent:fileName];
            UIImage *anImage = [UIImage imageWithContentsOfFile:imagePath];
            [tempImages addObject:anImage];
        }
        self.images = [tempImages copy];

        
        // Method 2: NSPurgableData
//        self.imageDataArray = [[NSMutableArray alloc] init];
//        for (NSInteger i = 0; i < [self imageCount]; i++)
//        {
//            [self.imageDataArray addObject:[NSNull null]];
//        }
        
    }
    return self;
}

- (NSInteger)imageCount;
{
    return [self.imageFileNames count];
}

// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark method 1
// -----------------------------------------------------------------------------------------------------------------
- (UIImage *)imageForIndex:(NSUInteger)theIndex;
{
    return [self.images objectAtIndex:theIndex];
}

// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark method 2
// -----------------------------------------------------------------------------------------------------------------

//- (UIImage *)imageForIndex:(NSUInteger)theIndex;
//{
//    id entry = [self.imageDataArray objectAtIndex:theIndex];
//    NSPurgeableData *imageData = (NSPurgeableData *)entry;
//    if (entry == [NSNull null] || ![imageData  beginContentAccess] )
//    {
//        NSString *fileName =  [self.imageFileNames objectAtIndex:theIndex];
//        NSString *imagePath = [self.fullResImagePath stringByAppendingPathComponent:fileName];
//        imageData = [[NSPurgeableData alloc] init];
//        [imageData setData:[NSData dataWithContentsOfFile:imagePath]];
//        [self.imageDataArray replaceObjectAtIndex:theIndex withObject:imageData];
//    }
//    
//    UIImage *image = [UIImage imageWithData:imageData];
//    [imageData endContentAccess];
//    
//    
//    return image;
//}



@end
