//
//  ViewController.m
//  Lab3Demo
//
//  Created by chat on 11.11.13.
//  Copyright (c) 2013 chat. All rights reserved.
//

#import "ViewController.h"
#import "ArrayConcurrency.h"

@interface ViewController ()
{
    NSOperationQueue *_myOpQueue;
    NSInteger _operationCounter;
}

@end

@implementation ViewController

- (void)awakeFromNib;
{
    _myOpQueue = [[NSOperationQueue alloc] init];
    _operationCounter = 0;
}

- (IBAction)onClickMakeSundae:(id)sender
{
    runArrayConcurrency();
    
    // POINT A: concurrency by selector
//    [self performSelectorInBackground:@selector(doTheWork) withObject:nil];
    
    
    // POINT B: concurrency by GCD
//    dispatch_queue_t aQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
//    dispatch_async(aQueue, ^(){
//        runArrayConcurrency();
//    });
    

//    // POINT C: concurrency by NSOperationQueue
//
//    // POINT D: controlling the queue
////    [_myOpQueue waitUntilAllOperationsAreFinished];
////    [_myOpQueue cancelAllOperations];
//    
//    _operationCounter++;
//    NSBlockOperation *blockOp = [NSBlockOperation blockOperationWithBlock:^()
//                                 {
//                                     NSLog(@"%d started", _operationCounter);
//                                     runArrayConcurrency();
//                                     NSLog(@"%d DONE", _operationCounter);
//                                 }];
//    [_myOpQueue addOperation:blockOp];
    
}


- (void)doTheWork;
{
    _operationCounter++;
    NSLog(@"%d started", _operationCounter);
    runArrayConcurrency();
    NSLog(@"%d DONE", _operationCounter);
}


@end


/*
 
 Teaching instruction
 =====================
 Purpose: Students understand how to implement concurrency with different strategies
 Prerequisite: Discussion in ArrayConcurrency.m
 
 Steps:
 1. POINT A performSelectorInBackground: need a dedicated selector, need to manage data handling, e.g., in a sepearate object as ivar
 2. POINT B GCD: added block support
 3. POINT C Operation Queue: more control over the operations
 4. POINT D controlling the operations in the queue
 
 Assignment: Read more about operation dependency and do A03.
 */



