//
//  ArrayConcurrency.m
//  Lab3Demo
//
//  Created by chat on 11.11.13.
//  Copyright (c) 2013 chat. All rights reserved.
//

#import "ArrayConcurrency.h"

void runArrayConcurrency()
{
    NSLog(@"\n\n============");
    
    // An array with flavor names
    NSArray *flavors;
    {
        flavors= [NSArray arrayWithObjects:
                        @"Chocolate",
                        @"Vanilla",
                        @"Chocolate chip",
                        @"Strawberry",
                        @"Chocolate fudge",
                        nil];
    }
    
    // A block to select only chocolate flavors
    BOOL (^onlyChocolateBlock)(id, NSUInteger, BOOL*) =
    ^ (id obj, NSUInteger idx, BOOL *stop)
    {
        return [(NSString *)obj hasPrefix:@"Chocolate"];
    };
    
    void (^sundaeBlock)(NSUInteger, BOOL *) =
    ^(NSUInteger idx, BOOL *stop)
    {
        // longOperation(10000);        // POINT B
        NSLog(@"%@", [[flavors objectAtIndex:idx] stringByAppendingString:@" Sundae"]);
    };
    
    // Extract the matching indices in parallel
    NSIndexSet *chocIndexSet =
        [flavors indexesOfObjectsWithOptions:NSEnumerationConcurrent
                                 passingTest:onlyChocolateBlock];

    // Perform a parallel operation with the indices
    [chocIndexSet enumerateIndexesWithOptions:0     // POINT A: NSEnumerationConcurrent
                                   usingBlock:sundaeBlock];
}

void longOperation(NSInteger n)
{
    // calculate all prime numbers until n
    NSInteger i = 3, count, c;
    for ( count = 2 ; count <= n ;  )
    {
        for ( c = 2 ; c <= i - 1 ; c++ )
        {
            if ( i%c == 0 )
                break;
        }
        if ( c == i )
        {
            count++;
        }
        i++;
    }
}

/*
 
 Teaching instruction
 =====================
 Purpose: Students understand how to implement concurrency using NSArray and debug such program

 Steps:
 1. Explain the code in overview and explain block syntax. (It's easier to fold the blocks at the start for an overview on the projector.)
 2. Ask students which of the three breakpoints will be stopped first (chockIndexSet line will be stopped. Breakpoints in block declarations are not executed yet.)
 3. Run the code to show the execution step. Once the breakpoint stops, step through to show the execution step.
 4. In sundaeBlock, make students notice that the code is run on the same thread.
 5. Change the flag to NSEnumerationConcurrent and run (POINT A)
 6. Note that new threads that are created for concurrent enumeration. Try printing out values of idx in the different threads to demonstrate that the debugger can change the frame into many threads.
 7. Run the code several times to show the different results in the consolde due to concurrency
 8. Uncomment the longOperation(10000) and run to slow down the execution. This blocks the UI. Discuss the solution in ViewController file (See Teaching Instruction there.)
 
 */