//
//  AppDelegate.m
//  SceneKitDemo2
//
//  Created by Torsten Kammer on 24.10.12.
//  Copyright (c) 2012 Torsten Kammer. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	SCNScene *scene = [SCNScene scene];
	self.view.scene = scene;
	
	SCNLight *ambient = [SCNLight light];
	ambient.color = [NSColor lightGrayColor];
	ambient.type = SCNLightTypeAmbient;
	SCNNode *ambientNode = [SCNNode node];
	ambientNode.light = ambient;
	[scene.rootNode addChildNode:ambientNode];
	
	SCNLight *light = [SCNLight light];
	light.color = [NSColor redColor];
	light.type = SCNLightTypeOmni;
	SCNNode *lightNode = [SCNNode node];
	lightNode.position = SCNVector3Make(-1, 1, 0);
	lightNode.light = light;
	[scene.rootNode addChildNode:lightNode];
	
	SCNGeometry *geometry = [SCNBox boxWithWidth:1 height:1 length:1 chamferRadius:0.25];
	SCNNode *geometryNode = [SCNNode nodeWithGeometry:geometry];
	[scene.rootNode addChildNode:geometryNode];
	
	SCNMaterial *material = [SCNMaterial material];
	material.ambient.contents = [NSImage imageNamed:@"NSComputer"];
	[geometry setFirstMaterial:material];
}

@end
