//
//  UIPageControl+BackStyle.h
//  Fabiji
//
//  Based on UIPageControl-I7BackStyle created by Jonas Schnelli.
//  http://github.com/jonasschnelli/UIPageControl-I7BackStyle
//
//  Created by Zhao He on 13/02/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "UIPageControl+BackStyle.h"


@implementation UIPageControl (BackStyle)

- (void)drawRect:(CGRect)rect 
{
	int i;
    
	for(i = 0; i < self.numberOfPages; i++) 
    {
		UIImageView *pageIcon = [self.subviews objectAtIndex:i];
		
		/* check for class type, in case of upcomming OS changes */
		if([pageIcon isKindOfClass:[UIImageView class]]) 
        {
			if(i==self.currentPage) {
				/* use the active image */
				pageIcon.image = [UIImage imageNamed: @"black_page_control_active.png"];
			}
			else {
				/* use the inactive image */
				pageIcon.image = [UIImage imageNamed: @"black_page_control.png"];
			}
		}
	}
}

/* you can alternatively add a methode swizzling, but i better not add the hackish code in case of a bad apple reviewer */
- (void)setCurrentPageBypass:(NSInteger)aPage
{
	[self setCurrentPage:aPage];
	[self setNeedsDisplay];
}

- (NSInteger)currentPageBypass
{
	return self.currentPage;
}


@end
