//
//  UIImage+Processing.m
//  Fabiji
//
//  Created by Zhao He on 12/03/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "UIImage+Processing.h"

@implementation UIImage (Processing)

+ (UIImage *)thumbnailImageForVideo:(NSURL *)videoURL atTime:(NSTimeInterval)time 
{
    AVURLAsset *asset = [[[AVURLAsset alloc] initWithURL:videoURL options:nil] autorelease];
    NSParameterAssert(asset);
    AVAssetImageGenerator *assetImageGenerator = [[[AVAssetImageGenerator alloc] initWithAsset:asset] autorelease];
    assetImageGenerator.appliesPreferredTrackTransform = YES;
    assetImageGenerator.apertureMode = AVAssetImageGeneratorApertureModeEncodedPixels;
    
    CGImageRef thumbnailImageRef = NULL;
    CFTimeInterval thumbnailImageTime = time;
    NSError *thumbnailImageGenerationError = nil;
    thumbnailImageRef = [assetImageGenerator copyCGImageAtTime:CMTimeMake(thumbnailImageTime, 60) actualTime:NULL error:&thumbnailImageGenerationError];
    
    if (!thumbnailImageRef)
        NSLog(@"thumbnailImageGenerationError %@", thumbnailImageGenerationError);
    
    UIImage *thumbnailImage = thumbnailImageRef ? [[[UIImage alloc] initWithCGImage:thumbnailImageRef] autorelease] : nil;
    
    return thumbnailImage;
}

+ (UIImage *)thumbnailImageWithContentsOfFile:(NSString *)path bounds:(CGSize)bounds
{
    UIImage *image = [UIImage imageWithContentsOfFile:path];
    
    UIImage *thumbnail = [image resizedImageWithContentMode:UIViewContentModeScaleAspectFill
                                                     bounds:bounds
                                       interpolationQuality:kCGInterpolationDefault];
    return thumbnail;
}

//self.thumbnailButton.bounds.size

@end
