//
//  TITokenFieldView+Utility.m
//  Fabiji
//
//  Created by Zhao He on 5/5/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "TITokenFieldView+Utility.h"

@implementation TITokenFieldView (Utility)

- (void)setupWithParentView:parentView sourceArray:(NSArray *)source placeHolderView:(UIView *)placeHolderView
{
    self.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    
    self.scrollEnabled = NO;
    self.tokenField.font = [UIFont systemFontOfSize:17];
    self.tokenField.textColor = [UIColor colorWithRed:0.22f green:0.33f blue:0.53f alpha:1.0f];
    if (placeHolderView) {
        [self addSubview:placeHolderView];
    }
    [parentView addSubview:self];
    [self.tokenField setPromptText:@""];
	[self setSourceArray:source];
	[self.tokenField setTokenizingCharacters:[NSCharacterSet characterSetWithCharactersInString:@",;."]]; // Default is a comma
}

@end
