//
//  NSString+UUID.m
//  Fabiji
//
//  Created by Zhao He on 2/23/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "NSString+Utility.h"

@implementation NSString (Utility)

+ (NSString *)stringWithUUID
{
    CFUUIDRef theUUID = CFUUIDCreate(kCFAllocatorDefault);
    
    if (theUUID) 
    {
        NSString *str = NSMakeCollectable(CFUUIDCreateString(kCFAllocatorDefault, theUUID));
        CFRelease(theUUID);
        return str;
    }
    
    return nil;
}

+ (NSString *)stringWithDocumentsPath
{
    NSArray *dirPaths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *str = [dirPaths objectAtIndex:0];
 
    return str;
}

+ (NSString *)stringWithUUIDInDocumentsPath
{
    NSString *documentsPath = [NSString stringWithDocumentsPath];
    NSString *UUID = [NSString stringWithUUID];
    NSString *str = [documentsPath stringByAppendingPathComponent:UUID];
    
    return str;
}

- (BOOL)isInArrayofStrings:(NSArray *)arrayOfStrings
{
    BOOL found = NO;
    for (NSString *s in arrayOfStrings)
    {
        if ([self rangeOfString:s].location != NSNotFound) {
            found = YES;
            break;
        }
    }
    return found;
}

- (NSString *)MIMEType
{
    NSString *ext = [[self pathExtension] lowercaseString];
    NSString *mimeType = @"";
    if ([ext isEqualToString:@"jpg"]) {
        mimeType = @"image/jpeg";
    }
    else if ([ext isEqualToString:@"png"]) {
        mimeType = @"image/png";
    }
    else if ([ext isEqualToString:@"mov"]) {
        mimeType = @"video/h264";
    }
    
    return mimeType;
}


@end
