//
//  NSArray+NameContents.m
//  Fabiji
//
//  Created by Zhao He on 05/05/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "NSArray+NameContents.h"
#import "FABTool.h"
#import "FABMaterial.h"
#import "FABLicense.h"
#import "FABTag.h"

@implementation NSArray (NameContents)

// Get name properties as array
- (NSMutableArray *)nameContentsArray
{
    NSMutableArray *nameContents = [[NSMutableArray alloc] init];
    
    if (self.count == 0) {
        nameContents = nil;
    }
    else 
    {
        id element = [self objectAtIndex:0];
        
        if ([element isKindOfClass:[FABTool class]]) {
            for (FABTool *tool in self) {
                [nameContents addObject:tool.name];
            }
        }
        else if ([element isKindOfClass:[FABMaterial class]]) {
            for (FABMaterial *material in self) {
                [nameContents addObject:material.name];
            }
        }
        else if ([element isKindOfClass:[FABLicense class]]) {
            for (FABLicense *license in self) {
                [nameContents addObject:license.name];
            }
        }
        else if ([element isKindOfClass:[FABTag class]]) {
            for (FABTag *tag in self) {
                [nameContents addObject:tag.name];
            }
        }
    }
    
    return [nameContents autorelease];
}

@end
