//
//  FABUser.m
//  Fabiji
//
//  Created by Zhao He on 2/22/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABUser.h"

@implementation FABUser

@synthesize identifier = _identifier;
@synthesize fullname = _fullname;
@synthesize email = _email;
@synthesize status = _status;
@synthesize projects = _projects;
@synthesize appointments = _appointments;

- (void)dealloc 
{
    [_identifier release];
    [_fullname release];
    [_email release];
    [_status release];
    [_projects release];
    [_appointments release];
    [super dealloc];
}

- (NSString *)description
{
    NSString *str = [NSString stringWithFormat:@"id: %@, fullname: %@, email: %@, status: %@, projects: %@", self.identifier, self.fullname, self.email, self.status, self.projects];
    return str;
}

- (NSComparisonResult)compare:(FABUser *)otherObject
{
    return [self.fullname localizedCaseInsensitiveCompare:otherObject.fullname];
}



@end
