//
//  FABRestHelper.m
//  Fabiji
//
//  Created by Zhao He on 29/04/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABRestHelper.h"
#import "FABAppointment.h"
#import "FABLicense.h"
#import "FABMaterial.h"
#import "FABMediafile.h"
#import "FABProject.h"
#import "FABTag.h"
#import "FABTool.h"
#import "FABUser.h"


static NSString* const FABRestAPIURLString = @"http://137.226.142.25:5080/wwwshare/restest/index.php";

@interface FABRestHelper()

+ (void)initObjectManager;
+ (void)initObjectMappings;
+ (void)initObjectRouter;
+ (void)configureGlobalDateFormat;

@end


@implementation FABRestHelper

#pragma mark - Public methods

+ (void)initBackendCommunication
{
    [self initObjectManager];
    [self initObjectMappings];
    [self initObjectRouter];
    [self configureGlobalDateFormat];
}


#pragma mark - Private methods

+ (void)initObjectManager
{
    RKObjectManager *objectManager = [RKObjectManager managerWithBaseURLString:FABRestAPIURLString];
    NSLog(@"%@", objectManager);
}

+ (void)initObjectMappings
{
    ///////////////////////////////////////
    //     Mapping for FABUser class     
    ///////////////////////////////////////
	
    // Setup our object mappings
    RKObjectMapping* userMapping = [RKObjectMapping mappingForClass:[FABUser class]];
    [userMapping mapKeyPath:@"user_id" toAttribute:@"identifier"];
    [userMapping mapKeyPath:@"name" toAttribute:@"fullname"];
    [userMapping mapKeyPath:@"email" toAttribute:@"email"];
    [userMapping mapKeyPath:@"status" toAttribute:@"status"];

    // Register our mappings with the provider using a resource path pattern
    [[RKObjectManager sharedManager].mappingProvider setMapping:userMapping forKeyPath:@"users"];
    
    // Configure a serialization mapping
    RKObjectMapping* userSerializationMapping = [userMapping inverseMapping];
    
    // Register the mapping with the provider
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:userSerializationMapping forClass:[FABUser class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABProject class   
    ///////////////////////////////////////
    
    RKObjectMapping *projectMapping = [RKObjectMapping mappingForClass:[FABProject class]];
    [projectMapping mapKeyPath:@"project_id" toAttribute:@"identifier"];
    [projectMapping mapKeyPath:@"title" toAttribute:@"titleOfProject"];
    [projectMapping mapKeyPath:@"description" toAttribute:@"descriptionOfProject"];
    [projectMapping mapKeyPath:@"thumbnail_file" toAttribute:@"thumbnailFileOfProject"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:projectMapping forKeyPath:@"projects"];
    RKObjectMapping *projectSerializationMapping = [projectMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:projectSerializationMapping forClass:[FABProject class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABAppointment class 
    ///////////////////////////////////////
    
    RKObjectMapping *appointmentMapping = [RKObjectMapping mappingForClass:[FABAppointment class]];
    [appointmentMapping mapKeyPath:@"appointment_id" toAttribute:@"identifier"];
    [appointmentMapping mapKeyPath:@"start_date" toAttribute:@"startDate"];
    [appointmentMapping mapKeyPath:@"end_date" toAttribute:@"endDate"];
    [appointmentMapping mapKeyPath:@"notes" toAttribute:@"notes"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:appointmentMapping forKeyPath:@"appointments"];
    RKObjectMapping *appointmentSerializationMapping = [appointmentMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:appointmentSerializationMapping forClass:[FABAppointment class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABTag class         
    ///////////////////////////////////////
    
    RKObjectMapping *tagMapping = [RKObjectMapping mappingForClass:[FABTag class]];
    [tagMapping mapKeyPath:@"tag_id" toAttribute:@"identifier"];
    [tagMapping mapKeyPath:@"name" toAttribute:@"name"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:tagMapping forKeyPath:@"tags"];
    RKObjectMapping *tagSerializationMapping = [tagMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:tagSerializationMapping forClass:[FABTag class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABMeidafile class  
    ///////////////////////////////////////
    
    RKObjectMapping *mediafileMapping = [RKObjectMapping mappingForClass:[FABMediafile class]];
    [mediafileMapping mapKeyPath:@"mediafile_id" toAttribute:@"identifier"];
    [mediafileMapping mapKeyPath:@"name" toAttribute:@"name"];
    [mediafileMapping mapKeyPath:@"type" toAttribute:@"type"];
    [mediafileMapping mapKeyPath:@"url" toAttribute:@"URL"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:mediafileMapping forKeyPath:@"mediafiles"];
    RKObjectMapping *mediafileSerializationMapping = [mediafileMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:mediafileSerializationMapping forClass:[FABMediafile class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABLicense class  
    ///////////////////////////////////////
    
    RKObjectMapping *licenseMapping = [RKObjectMapping mappingForClass:[FABLicense class]];
    [licenseMapping mapKeyPath:@"license_id" toAttribute:@"identifier"];
    [licenseMapping mapKeyPath:@"name" toAttribute:@"name"];
    [licenseMapping mapKeyPath:@"description" toAttribute:@"descriptionInDetail"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:licenseMapping forKeyPath:@"licenses"];
    RKObjectMapping *licenseSerializationMapping = [licenseMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:licenseSerializationMapping forClass:[FABLicense class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABTool class  
    ///////////////////////////////////////
    
    RKObjectMapping *toolMapping = [RKObjectMapping mappingForClass:[FABTool class]];
    [toolMapping mapKeyPath:@"tool_id" toAttribute:@"identifier"];
    [toolMapping mapKeyPath:@"name" toAttribute:@"name"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:toolMapping forKeyPath:@"tools"];
    RKObjectMapping *toolSerializationMapping = [toolMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:toolSerializationMapping forClass:[FABTool class]];
    
    
    ///////////////////////////////////////
    //    Mapping for FABMaterial class  
    ///////////////////////////////////////
    
    RKObjectMapping *materialMapping = [RKObjectMapping mappingForClass:[FABMaterial class]];
    [materialMapping mapKeyPath:@"material_id" toAttribute:@"identifier"];
    [materialMapping mapKeyPath:@"name" toAttribute:@"name"];
    
    [[RKObjectManager sharedManager].mappingProvider setMapping:materialMapping forKeyPath:@"materials"];
    RKObjectMapping *materialSerializationMapping = [materialMapping inverseMapping];
    [[RKObjectManager sharedManager].mappingProvider setSerializationMapping:materialSerializationMapping forClass:[FABMaterial class]];
    
    
    
    ///////////////////////////////////////
    //    Relationship mappings            
    ///////////////////////////////////////
    [userMapping mapKeyPath:@"projects" toRelationship:@"projects" withMapping:projectMapping];
    [userMapping mapKeyPath:@"appointments" toRelationship:@"appointments" withMapping:appointmentMapping];
    [projectMapping mapKeyPath:@"tags" toRelationship:@"tagsOfProject" withMapping:tagMapping];
    [projectMapping mapKeyPath:@"mediafiles" toRelationship:@"mediaFilesOfProject" withMapping:mediafileMapping];
    [projectMapping mapKeyPath:@"license" toRelationship:@"licenseOfProject" withMapping:licenseMapping];
    [projectMapping mapKeyPath:@"tools" toRelationship:@"toolsOfProject" withMapping:toolMapping];
    [projectMapping mapKeyPath:@"materials" toRelationship:@"materialsOfProject" withMapping:materialMapping];
}

+ (void)initObjectRouter
{
    RKObjectRouter *router = [RKObjectManager sharedManager].router;
    [router routeClass:[FABAppointment class] toResourcePath:@"/appointments/:identifier"];
    [router routeClass:[FABAppointment class] toResourcePath:@"/appointments" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABUser class] toResourcePath:@"/users/:identifier"];
    [router routeClass:[FABUser class] toResourcePath:@"/users" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABProject class] toResourcePath:@"/projects/:identifier"];
    [router routeClass:[FABProject class] toResourcePath:@"/projects" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABMediafile class] toResourcePath:@"/mediafiles/:identifier"];
    [router routeClass:[FABMediafile class] toResourcePath:@"/mediafiles" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABLicense class] toResourcePath:@"/licenses/:identifier"];
    [router routeClass:[FABLicense class] toResourcePath:@"/licenses" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABTool class] toResourcePath:@"/tools/:identifier"];
    [router routeClass:[FABTool class] toResourcePath:@"/tools" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABMaterial class] toResourcePath:@"/materials/:identifier"];
    [router routeClass:[FABMaterial class] toResourcePath:@"/materials" forMethod:RKRequestMethodPOST];
    [router routeClass:[FABTag class] toResourcePath:@"/tags/:identifier"];
    [router routeClass:[FABTag class] toResourcePath:@"/tags" forMethod:RKRequestMethodPOST];
}

+ (void)configureGlobalDateFormat
{
    NSDateFormatter *dateFormatter = [[NSDateFormatter new] autorelease];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss Z"];
    dateFormatter.timeZone = [NSTimeZone defaultTimeZone];
    dateFormatter.locale = [NSLocale currentLocale];
    [RKObjectMapping setPreferredDateFormatter:dateFormatter];
}



@end
