//
//  FABProjectsSectionViewController.h
//  Fabiji
//
//  Created by Zhao He on 2/15/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <RestKit/RestKit.h>
#import "FABPickerViewController.h"
#import "FABProject.h"
#import "FABPlistHelper.h"
#import "TITokenField.h"

@interface FABProjectsSectionViewController : UITableViewController <FABPickerDelegate, UITextViewDelegate, UITextFieldDelegate, TITokenFieldDelegate, RKObjectLoaderDelegate>


@property (assign, nonatomic) CGFloat cellTextHeight;
@property (retain, nonatomic) FABProject *currentProject;
@property (retain, nonatomic) NSMutableArray *availableTools;
@property (retain, nonatomic) NSMutableArray *availableMaterials;
@property (retain, nonatomic) NSMutableArray *availableLicenses;
@property (retain, nonatomic) NSMutableArray *availableTags;
@property (retain, nonatomic) UITextView *descriptionTextView;
@property (retain, nonatomic) TITokenField *toolsTextField;
@property (retain, nonatomic) TITokenField *materialsTextField;
@property (retain, nonatomic) UITextField *licenseTextField;
@property (retain, nonatomic) TITokenField *tagsTextField;
@property (retain, nonatomic) UIPopoverController *pickerPopoverController;

@property (retain, nonatomic) IBOutlet UITableViewCell *descriptionCell;
@property (retain, nonatomic) IBOutlet UITableViewCell *toolsCell;
@property (retain, nonatomic) IBOutlet UITableViewCell *materialsCell;
@property (retain, nonatomic) IBOutlet UITableViewCell *licenseCell;
@property (retain, nonatomic) IBOutlet UITableViewCell *tagsCell;
@property (retain, nonatomic) IBOutlet UILabel *tagsHintLabel;


- (void)configureView;
- (void)updateHeightOfTableViewWithTextView:(UITextView *)textView;

@end
