//
//  FABProjectsMasterViewController.m
//  Fabiji
//
//  Created by Zhao He on 21/02/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectsMasterViewController.h"

@interface FABProjectsMasterViewController()

@property (nonatomic, assign) bool isGETRequest;

- (void)loadUsers;

@end


@implementation FABProjectsMasterViewController

@synthesize isGETRequest = _isGETRequest;
@synthesize editingTextField = _editingTextField;
@synthesize users = _users;
@synthesize listViewController = _listViewController;


// Called when the view controller is create from NIB
- (id)initWithCoder:(NSCoder *)coder 
{
    self = [super initWithCoder:coder];
    if (self) 
    {
        self.users = [[NSMutableArray alloc] init];
        [self loadUsers];
    }
    return self;
}

- (void)dealloc 
{
    [_editingTextField release];
    [_users release];
    [_listViewController release];
    [super dealloc];
}


#pragma mark - RestKit

- (void)createUser:(FABUser *)user;
{
    // POST to /users
    [[RKObjectManager sharedManager] postObject:user delegate:self];
    self.isGETRequest = NO;
}

- (void)loadUsers
{
    // GET /users
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/users" delegate:self];
    self.isGETRequest = YES;
}

- (void)request:(RKRequest*)request didLoadResponse:(RKResponse*)response 
{
    //NSLog(@"Response: %@", [response bodyAsString]);
    NSLog(@"Status: %d", [response statusCode]);
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didLoadObjects:(NSArray *)objects 
{
	//NSLog(@"Loaded object: %@", objects);
    if (self.isGETRequest)
    {
        self.users = [NSMutableArray arrayWithArray:objects];
    }
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}

#pragma mark - IBActions

- (IBAction)cancelButtonTapped:(id)sender
{
    NSLog(@"cancelButtonTapped");
    [self.editingTextField resignFirstResponder];
    [self setEditing:YES animated:YES];
}

- (IBAction)doneButtonTapped:(id)sender
{
    NSLog(@"doneButtonTapped");
    [self addNewUser:self.editingTextField];
    [self setEditing:YES animated:YES];
}

- (IBAction)addButtonTapped:(id)sender
{
    NSLog(@"addButtonTapped:");
    UIBarButtonItem *cancelButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemCancel target:self action:@selector(cancelButtonTapped:)];
    self.navigationItem.leftBarButtonItem = cancelButton;
    
    [self setEditing:NO animated:YES];
}


# pragma mark - Public methods

- (void)setEditing:(BOOL)editing animated:(BOOL)animated 
{
    if(editing)
	{
		[super setEditing:NO animated:YES]; 
		[self.tableView reloadData];
        
        self.navigationItem.leftBarButtonItem = nil;
        UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAdd target:self action:@selector(addButtonTapped:)];
        self.navigationItem.rightBarButtonItem = addButton;
	}
	else
	{
		[super setEditing:YES animated:YES]; 
		[self.tableView reloadData];
        
        self.navigationItem.rightBarButtonItem = nil;
        UIBarButtonItem *doneButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(doneButtonTapped:)];
        self.navigationItem.rightBarButtonItem = doneButton;
	}
    
    NSLog(@"self.users.count = %d", self.users.count);
}



- (void)addNewUser:(UITextField *)textField
{
    //FABUser *newUser = [[FABUser alloc] initWithFullName:@""];
    FABUser *newUser = [[[FABUser alloc] init] autorelease];
    newUser.fullname = textField.text;
    
    // Insert a new user if fullname entered is not empty
    if ( [newUser.fullname length] ) 
    {
        // Add to users
        [self.users insertObject:newUser atIndex:self.users.count];
        
        // Animation
        [self setEditing:YES animated:YES];
        
        //Upadte database
        //[FABPlistHelper plistAddUser:newUser];
        [self createUser:newUser];
        
        // Select the newly added user
        int lastRow = self.users.count - 1;
        NSIndexPath *lastRowIndexPath = [NSIndexPath indexPathForRow:lastRow inSection:0];
        [[self.tableView delegate] tableView:self.tableView didSelectRowAtIndexPath:lastRowIndexPath];
    }
}



#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.title = @"Users";

    // Add "+" button
    UIBarButtonItem *addButton = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAdd target:self action:@selector(addButtonTapped:)] autorelease];
    self.navigationItem.rightBarButtonItem = addButton;
    
    // Directly push to listViewController
    self.listViewController = [[[FABProjectsListViewController alloc] initWithStyle:UITableViewStyleGrouped] autorelease];
    self.listViewController.currentUser = nil;
    [self.navigationController pushViewController:self.listViewController animated:YES];
}

- (void)viewDidUnload {
    [self setListViewController:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if ([tableView isEditing]) {
        return [self.users count] + 1;
    }
    
    return [self.users count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *MyIdentifier = @"TextFieldCell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:MyIdentifier];
    if (cell == nil) {
        // Load the top-level objects from the custom cell XIB.
        NSArray *topLevelObjects = [[NSBundle mainBundle] loadNibNamed:@"TextFieldCell" owner:self options:nil];
        // Grab a pointer to the first object (presumably the custom cell, as that's all the XIB should contain).
        cell = [topLevelObjects objectAtIndex:0];
    }
    
    // Configure the add row
    if(indexPath.row == ([self.users count]) && self.editing)
	{
        UITextField *textField = (UITextField *)[cell viewWithTag:1];
        textField.enabled = YES;
        textField.text = @"";
        textField.placeholder = @"Create New User...";
        textField.delegate = self;
        [textField becomeFirstResponder];
		return cell;
	}
    
    UITextField *textField = (UITextField *)[cell viewWithTag:1];
    textField.enabled = NO;
    textField.text = [[self.users objectAtIndex:indexPath.row] fullname];

    return cell;
}

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if ( !self.listViewController ) 
    {
        _listViewController = [[FABProjectsListViewController alloc] initWithNibName:@"FABProjectsListViewController" bundle:nil];
    }
    
    self.listViewController.currentUser = [self.users objectAtIndex:indexPath.row];
    [self.navigationController pushViewController:self.listViewController animated:YES];    
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) 
    {
        [self.users removeObjectAtIndex:indexPath.row];
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) 
    {
        NSLog(@"commitEditingStyle: insert");
    }
}

- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    // No editing style if not editing or the index path is nil.
    if (tableView.editing == NO || !indexPath)
    {
        return UITableViewCellEditingStyleNone;
    }
    
    // Add "+" symbol in front of the last row
    if (self.editing && indexPath.row == ([self.users count])) 
	{
		return UITableViewCellEditingStyleInsert;
	}
    
    else 
	{
		return UITableViewCellEditingStyleDelete;
	}
    return UITableViewCellEditingStyleNone;
}


#pragma mark - UITextField delegation

- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    self.editingTextField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    [textField resignFirstResponder];
    self.editingTextField = nil;
    [self setEditing:YES animated:YES];
}

// Process enter key
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self addNewUser:textField];
    return NO;
}


@end
