//
//  FABProjectsDetailViewController.m
//  Fabiji
//
//  Created by Zhao He on 06/02/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectsDetailViewController.h"
#import "FABProjectsSectionViewController.h"
#import "FABProjectsListViewController.h"
#import "FABConfigHelper.h"
#import "SHKTwitter.h"
#import "SHKFacebook.h"
#import "FABMediafile.h"
#import "NSString+Utility.h"
#import "UIImage+FixOrientation.h"

static NSString* const FABTakePhotoChoice = @"Take Photo";
static NSString* const FABChoosePhotoChoice = @"Choose Photo";
static NSString* const FABEmailChoice = @"Email";
static NSString* const FABTwitterChoice = @"Twitter";
static NSString* const FABFacebookChoice = @"Facebook";
static NSString* const FABLogInChoice = @"Log In As";
static NSString* const FABLogOutChoice = @"Log Out";
static NSString* const FABCurrentUsers = @"Display Current Users";

@interface FABProjectsDetailViewController()

@property (nonatomic, assign) BOOL isUploadMediafile;

@end


@implementation FABProjectsDetailViewController

@synthesize isUploadMediafile = _isUploadMediafile;
@synthesize numberBadge = _numberBadge;
@synthesize currentUser = _currentUser;
@synthesize currentProject = _currentProject;
@synthesize currentActionSheet = _currentActionSheet;
@synthesize cameraActionSheet = _cameraActionSheet;
@synthesize exportActionSheet = _exportActionSheet;
@synthesize configActionSheet = _configActionSheet;
@synthesize cameraPickerPopover = _cameraPickerPopover;
@synthesize takePhotoPicker = _takePhotoPicker;
@synthesize choosePhotoPicker = _choosePhotoPicker;
@synthesize sectionTableView = _sectionTableView;

@synthesize cameraBarButtonItem = _cameraBarButtonItem;
@synthesize scrollView = _scrollView;
@synthesize thumbnailButton = _thumbnailButton;
@synthesize logInHintView = _logInHintView;
@synthesize configBarButtonItem = _configBarButtonItem;
@synthesize exportBarButtonItem = _exportBarButtonItem;
@synthesize toolBarTitleButtonItem = _toolBarTitleButtonItem;
@synthesize toolBar = _toolBar;

@synthesize delegate = _delegate;

- (void)dealloc 
{
    [_numberBadge release];
    [_currentUser release];
    [_currentProject release];
    [_currentActionSheet release];
    [_cameraActionSheet release];
    [_cameraPickerPopover release];
    [_configActionSheet release];
    [_takePhotoPicker release];
    [_choosePhotoPicker release];
    [_sectionTableView release];
    
    [_toolBar release];
    [_scrollView release];
    [_cameraBarButtonItem release];
    [_toolBarTitleButtonItem release];
    [_thumbnailButton release];
    [_exportBarButtonItem release];
    
    _delegate = nil;
    [_configBarButtonItem release];
    [_logInHintView release];
    [super dealloc];
}

#pragma mark - RestKit

// Load online users
- (void)displayCurrentUsersTapped
{
    // GET to /users/online
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/users/online" delegate:self];
    self.isUploadMediafile = NO;
}

// Load all users
- (void)logInAsTapped
{
    // GET to /users
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/users" delegate:self];
    self.isUploadMediafile = NO;
}

- (void)uploadMediafile:(NSString *)filePath fileName:(NSString *)fileName toProjectWithID:(NSNumber *)pid
{
    RKParams* params = [RKParams params];
    RKParamsAttachment* attachment = [params setFile:filePath forParam:@"file"];
    attachment.MIMEType = [fileName MIMEType];
    attachment.fileName = fileName;
    NSLog(@"MIMEType: %@", attachment.MIMEType);
    
    NSString *request = [NSString stringWithFormat:@"/projects/%@/mediafiles", pid];
    [[RKClient sharedClient] post:request params:params delegate:self];
    self.isUploadMediafile = YES;
}

- (void)deleteMediafileWithID:(NSNumber *)fid
{
    NSString *request = [NSString stringWithFormat:@"/mediafiles/%@", fid];
    [[RKClient sharedClient] delete:request delegate:self];
    self.isUploadMediafile = NO;
}

- (void)updateCurrentProject
{    
    // PUT to /projects/pid
    [ [RKObjectManager sharedManager] putObject:self.currentProject delegate:self];
    self.isUploadMediafile = NO;
}

- (void)request:(RKRequest*)request didLoadResponse:(RKResponse*)response 
{
    //NSLog(@"Response: %@", [response bodyAsString]);
    //NSLog(@"Status: %d", [response statusCode]);
    if ([response isOK]) {
        NSLog(@"response isOK.");
    }
    else if([response isCreated]) {
        NSLog(@"response isCreated.");
    }
    
    // :uploadMediafile
    if (request.method == RKRequestMethodPOST)
    {
        // GET /mediafiles/id, id is extracted from response
        NSDictionary *dict = [response parsedBody:nil];
        dict = [dict objectForKey:@"mediafiles"];
        NSNumber *identifier = [dict objectForKey:@"mediafile_id"];
        [[RKObjectManager sharedManager] loadObjectsAtResourcePath:[NSString stringWithFormat:@"/mediafiles/%@", identifier] delegate:self];
    }
    
    // :updateCurrentProject
    if (request.method == RKRequestMethodPUT) {
        // Inform gallery view
        [self.delegate thumbnailDidChange];
    }
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didLoadObjects:(NSArray *)objects 
{
    NSLog(@"objectLoader.resourcePath: %@", objectLoader.resourcePath);
    
    // :uploadMediafile
    if (self.isUploadMediafile == YES) 
    {
        // Update current project
        FABMediafile *mediafile = [objects objectAtIndex:0];
        [self.currentProject.mediaFilesOfProject addObject:mediafile];
        self.currentProject.thumbnailFileOfProject = [mediafile URL];
        [self updateCurrentProject];
    }
    
    // :displayCurrentUsersTapped
    else if (objectLoader.resourcePath == @"/users/online") 
    {
        // Display only users who has status = 1
        [FABConfigHelper presentCurrentUsersViewController:self withUsers:objects];
    }
    
    // :logInAsTapped
    else if (objectLoader.resourcePath == @"/users")
    {
        // Display all users
        [FABConfigHelper presentLoginFromViewController:self withUsers:objects currentUser:self.currentUser];
    }
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}


#pragma mark - Managing the detail item

- (void)setCurrentUser:(FABUser *)newUser
{
    if (_currentUser != newUser) {
        [_currentUser release];
        _currentUser = [newUser retain];
    }
    
    if (_currentUser.projects.count == 0) 
    {
        [self setCurrentProject:nil];
    }
}

- (void)setCurrentProject:(FABProject *)newProject
{
    if (_currentProject != newProject) {
        [_currentProject release]; 
        _currentProject = [newProject retain]; 
    }
    
    // Update the view.
    [self configureView];
}

- (void)configureView
{ 
    if (self.currentProject) 
    {
        // Show everything if it is hidden
        if (self.scrollView.hidden) 
        {
            self.scrollView.hidden = NO;
            for (UIView *view in self.toolBar.subviews) 
            {
                view.hidden = NO;
            }
        }
        
        // Hide hint view if there is user
        if (self.currentUser) {
            self.logInHintView.hidden = YES;
        }
        
        // Set title and thumnail image
        self.toolBarTitleButtonItem.title = self.currentProject.titleOfProject;
        
        // setNeedsDisplay does the magic that removes error
        // if detailViewController is pushed from a navigation viewController
        [self.view setNeedsDisplay];
        NSString *smallThumbnailPath = [self.currentProject.thumbnailFileOfProject stringByAppendingFormat:@"/small"];
        [self.thumbnailButton setBackgroundImage:[self imageAtRemoteURLPath:smallThumbnailPath] forState:UIControlStateNormal];
        
        // Replace bdage
        NSInteger numberOfMedia = [self.currentProject.mediaFilesOfProject count];
        [self replaceWithNewBadge:[CustomBadge badgeWithNumber:numberOfMedia]];
        
        // Pass project object to the tableView
        self.sectionTableView.currentProject = self.currentProject;
    }
    
    else
    {
        self.toolBarTitleButtonItem.title = @"";
    }
}

- (void)replaceWithNewBadge:(CustomBadge *)badge
{
    // Remove old badge
    [self.numberBadge removeFromSuperview];
    [self.numberBadge release];
    
    // Add new badge to view only if there are more than one image
    if (badge) 
    {
        self.numberBadge = [badge retain];
        NSInteger numberOfMedia = [badge.badgeText intValue];
        if (numberOfMedia > 1) 
        {
            CGFloat x = self.thumbnailButton.frame.origin.x + self.thumbnailButton.frame.size.width - 10;
            CGFloat y = self.thumbnailButton.frame.origin.y - 10;
            
            badge.frame = CGRectMake(x, y, 25, 25);
            [self.scrollView addSubview:badge];
        }
    }
}


#pragma mark - IBActions

- (IBAction)thumbnailButtonTapped:(id)sender 
{
    if (self.currentProject.mediaFilesOfProject.count == 0)
    {
        [self cameraPopover];
    }
    
    else
    {
        KTPhotoScrollViewController *photoBrowserController = [[KTPhotoScrollViewController alloc] 
                                                  initWithDataSource:self 
                                                  andStartWithPhotoAtIndex:self.currentProject.mediaFilesOfProject.count-1];
    
        [self.splitViewController.navigationItem setTitle:self.currentProject.titleOfProject];
        [self.splitViewController.navigationController pushViewController:photoBrowserController animated:YES];
        [photoBrowserController release];
    }
}

- (IBAction)exportButtonTapped:(id)sender 
{
    NSLog(@"actionButtonTapped:");
    if (self.exportActionSheet == nil)
    {
        self.exportActionSheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles: FABEmailChoice, FABTwitterChoice, FABFacebookChoice, nil] autorelease];
    }
    
    // Dismiss current ActionSheet in display
    if (self.currentActionSheet) {
        [self.currentActionSheet dismissWithClickedButtonIndex:-1 animated:YES];
    }
    
    // Show Camera ActionSheet
    [self.exportActionSheet showFromBarButtonItem:self.exportBarButtonItem animated:YES];
    self.currentActionSheet = self.exportActionSheet;
}


- (void)cameraPopover
{
    bool frontCameraIsAvailable = [UIImagePickerController isCameraDeviceAvailable:UIImagePickerControllerCameraDeviceFront];
    bool rearCameraIsAvailable = [UIImagePickerController isCameraDeviceAvailable:UIImagePickerControllerCameraDeviceRear];
    
    if (self.cameraActionSheet == nil)
    {
        // If camera detected, show "Take Photo" and "Choose Photo" options
        if ( frontCameraIsAvailable || rearCameraIsAvailable)
        {
            self.cameraActionSheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles:FABTakePhotoChoice, FABChoosePhotoChoice, nil] autorelease];
        }
        
        // If no camera detected, only show "Choose Photo" option
        else
        {
            self.cameraActionSheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles: FABChoosePhotoChoice, nil] autorelease];
        }        
    }
    
    // Dismiss current ActionSheet in display
    if (self.currentActionSheet) {
        [self.currentActionSheet dismissWithClickedButtonIndex:-1 animated:YES];
    }
    
    // Show Camera ActionSheet
    [self.cameraActionSheet showFromBarButtonItem:self.cameraBarButtonItem animated:YES];
    self.currentActionSheet = self.cameraActionSheet;
}

- (IBAction)cameraButtonTapped:(id)sender
{
    NSLog(@"cameraButtonTapped:");
    [self cameraPopover];
}

- (IBAction)configButtonTapped:(id)sender 
{
    // Creat a new config popover dynamically
    NSString *logoutOrNil = self.currentUser == nil ? nil : FABLogOutChoice;
    self.configActionSheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:nil destructiveButtonTitle:logoutOrNil otherButtonTitles: FABLogInChoice, FABCurrentUsers, nil] autorelease];

    // Dismiss current ActionSheet in display
    if (self.currentActionSheet) {
        [self.currentActionSheet dismissWithClickedButtonIndex:-1 animated:YES];
    }
    
    // Show Camera ActionSheet
    [self.configActionSheet showFromBarButtonItem:self.configBarButtonItem animated:YES];
    self.currentActionSheet = self.configActionSheet;
}




#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _sectionTableView = [[FABProjectsSectionViewController alloc] initWithNibName:@"FABProjectsSectionViewController" bundle:[NSBundle mainBundle]];
    self.sectionTableView.view.frame = CGRectMake(20, 200, 703, 700);
    
    // Add to scroll view
    [self.scrollView addSubview:self.sectionTableView.view];
    
    // Add rounded border for thumbnailButton
    [self.thumbnailButton addRoundedBorder];
    

    // Set ScrollView content size
    self.scrollView.contentSize = CGSizeMake(703, 655);
    self.scrollView.scrollEnabled = YES;
    
    // Hide all views except toolbar before user select any project
    self.scrollView.hidden = YES;
//    for (UIView *view in self.toolBar.subviews) {
//        view.hidden = YES;
//    }
     
    
    // Instantiate ImagePickerController before using it to save camera loading time
    self.takePhotoPicker = [[[UIImagePickerController alloc] init] autorelease];
    self.takePhotoPicker.delegate = self;
 
    self.choosePhotoPicker = [[[UIImagePickerController alloc] init] autorelease];
    self.choosePhotoPicker.delegate = self;
    
    
    // Setup detailItems
    [self configureView];
}



// setNavigationBarHidden must be in the detailView instead of masterView 
// otherwise there is a gap at the bottom
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.splitViewController.navigationController setNavigationBarHidden:YES animated:NO];
}

- (void)viewDidUnload 
{
    [self setNumberBadge:nil];
    [self setToolBar:nil];
    [self setScrollView:nil];
    [self setCameraBarButtonItem:nil];
    [self setToolBarTitleButtonItem:nil];
    [self setThumbnailButton:nil];
    [self setExportBarButtonItem:nil];
    [self setConfigBarButtonItem:nil];
    [self setLogInHintView:nil];
    [super viewDidUnload];
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

#pragma mark - UIActionSheet delegations

- (void)actionSheet:(UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex
{
    // -1 means actionSheet is dismissed
    if (buttonIndex == -1) {
        return;
    }
    
    // Get the selected button string
    NSString *choice = [actionSheet buttonTitleAtIndex:buttonIndex];
    
    if ([choice isEqualToString:FABTakePhotoChoice]) 
    {
        // PHOTO ONLY!! As server API doens't support movie
        //self.takePhotoPicker.mediaTypes = [UIImagePickerController availableMediaTypesForSourceType:UIImagePickerControllerSourceTypeCamera];
        self.takePhotoPicker.mediaTypes = [NSArray arrayWithObjects: (NSString *) kUTTypeImage, nil];
        self.takePhotoPicker.sourceType = UIImagePickerControllerSourceTypeCamera;
        self.takePhotoPicker.allowsEditing = NO;
        self.takePhotoPicker.videoQuality = UIImagePickerControllerQualityTypeHigh;
        [self presentModalViewController:self.takePhotoPicker animated:YES];
    } 
    
    // Displays saved pictures and movies, if both are available, from the Camera Roll album.
    else if ([choice isEqualToString:FABChoosePhotoChoice]) 
    {
        // PHOTO ONLY!! As server API doens't support movie
        //self.choosePhotoPicker.mediaTypes = [UIImagePickerController availableMediaTypesForSourceType:UIImagePickerControllerSourceTypeSavedPhotosAlbum];
        self.choosePhotoPicker.mediaTypes = [NSArray arrayWithObjects: (NSString *) kUTTypeImage, nil];
        self.choosePhotoPicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
        self.choosePhotoPicker.allowsEditing = NO;
        
        // Show image picker popover
        self.cameraPickerPopover = [[[UIPopoverController alloc] initWithContentViewController:self.choosePhotoPicker] autorelease];
        [self.cameraPickerPopover presentPopoverFromBarButtonItem:self.cameraBarButtonItem permittedArrowDirections:UIPopoverArrowDirectionAny animated:YES];
    }
    
    else if([choice isEqualToString:FABEmailChoice])
    {
        FABMailComposer *mail = [[FABMailComposer alloc] initWithProject:self.currentProject];
        MFMailComposeViewController* controller = [[[MFMailComposeViewController alloc] init] autorelease];
        
        if ([MFMailComposeViewController canSendMail]) 
        {
            controller.mailComposeDelegate = self;
            [controller setSubject:mail.subject];
            [controller setMessageBody:mail.messageBody isHTML:NO]; 
            for (FABMediafile *mediafile in self.currentProject.mediaFilesOfProject) {
                NSData *data = [self dataAtRemoteURLPath:mediafile.URL];
                NSString *mimeType = mediafile.type;
                [controller addAttachmentData:data mimeType:mimeType fileName:mediafile.name];
            }
            controller.modalPresentationStyle = UIModalPresentationFormSheet;
            [self.parentViewController presentModalViewController:controller animated:YES];
        }
    }
    
    else if([choice isEqualToString:FABTwitterChoice])
    {
        UIImage *thumbnail = [self imageAtRemoteURLPath:self.currentProject.thumbnailFileOfProject];
        SHKItem *item = [SHKItem image:thumbnail title:[NSString stringWithFormat:@"%@ has just created %@!", self.currentUser.fullname, self.currentProject.titleOfProject]];
        [SHKTwitter shareItem:item];
    }
    else if([choice isEqualToString:FABFacebookChoice])
    {
        UIImage *thumbnail = [self imageAtRemoteURLPath:self.currentProject.thumbnailFileOfProject];
        SHKItem *item = [SHKItem image:thumbnail title:[NSString stringWithFormat:@"%@ has just created %@!", self.currentUser.fullname, self.currentProject.titleOfProject]];
        [SHKFacebook shareItem:item];
    }
    
    else if([choice isEqualToString:FABLogOutChoice])
    {
        UIAlertView *alert = [[[UIAlertView alloc] initWithTitle:@"Warning" 
                                           message:[NSString stringWithFormat:@"Are you sure to log out now as %@?\n (all data will be saved safely)", self.currentUser.fullname] 
                                          delegate:self cancelButtonTitle:@"Cancel" 
                                 otherButtonTitles:@"Log Out", nil] autorelease];
        [alert show];
    }
    
    else if([choice isEqualToString:FABLogInChoice])
    {
        [self logInAsTapped];
    }
    
    else if([choice isEqualToString:FABCurrentUsers])
    {
        [self displayCurrentUsersTapped];
    }
    
    else
    {
        NSLog(@"Unrecognized Choice: %@", choice);
    }
}

- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    NSLog(@"didDismissWithButtonIndex: %d", buttonIndex);
    self.cameraActionSheet = nil;
}

#pragma mark - UIAlertView delegations

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    NSString *title = [alertView buttonTitleAtIndex:buttonIndex];
    
    if([title isEqualToString:@"Cancel"])
    {
        // NSLog(@"Cancel log out...");
    }
    else if([title isEqualToString:@"Log Out"])
    {
        // Update user status on Server
        [FABConfigHelper updateUser:self.currentUser withStatus:[NSNumber numberWithBool:NO]];
        
        // Update current view
        self.currentUser = nil;
        self.logInHintView.hidden = NO;
        
        // Update list view
        UINavigationController *navigationController = [self.splitViewController.viewControllers objectAtIndex:0];
        FABProjectsListViewController *listVC = [navigationController.viewControllers objectAtIndex:1];
        listVC.currentUser = nil;
    }
}


#pragma mark - MFMailComposeViewController delegations

- (void)mailComposeController:(MFMailComposeViewController*)controller  
          didFinishWithResult:(MFMailComposeResult)result 
                        error:(NSError*)error;
{
    if (result == MFMailComposeResultSent) {
        NSLog(@"Email sent!");
    }
    [self dismissModalViewControllerAnimated:YES];
}


#pragma mark - UIImagePickerController delegations

- (void)setThumbnailFromImage:(UIImage *)image toPath:(NSString *)path
{
    UIImage *thumbnail = [image resizedImageWithContentMode:UIViewContentModeScaleAspectFill
                                                     bounds:self.thumbnailButton.bounds.size
                                       interpolationQuality:kCGInterpolationDefault];
    [self.thumbnailButton setBackgroundImage:thumbnail forState:UIControlStateNormal];
    
    // TRICKY!! New mediafile object is not added to mediaFilesOfProject 
    // until asynchonized call finished from RestKit, so we manually +1
    // to the mediaFilesOfProject count
    NSInteger numberOfMedia = [self.currentProject.mediaFilesOfProject count] + 1;
    [self replaceWithNewBadge:[CustomBadge badgeWithNumber:numberOfMedia]];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    NSString* mediaType = [info objectForKey:UIImagePickerControllerMediaType];
    NSString *documentsPath = [NSString stringWithDocumentsPath];
    NSString *mediaSavePath;
    NSString *filename;
    
    // If media type is photo
    if ( [ mediaType isEqualToString:(NSString *)kUTTypeImage ]) 
    {                                                
        UIImage *image = [info objectForKey:UIImagePickerControllerOriginalImage];
        [image fixOrientation];
    
        if (picker == self.takePhotoPicker) {
           
            // Save uncropped image to Camera Roll album
            UIImageWriteToSavedPhotosAlbum(image, self, @selector(image:didFinishSavingWithError:ContextInfo:), @"image");
            
            // Save uncropped image to Documents folder with newly generated UUID.JPG
            NSString *UUID = [NSString stringWithUUID];
            filename = [UUID stringByAppendingPathExtension:@"jpg"];
        }
        
        // Choose photo from library
        if (picker == self.choosePhotoPicker) {
            
            // Get UUID of selected Photo or Movie
            NSURL *referenceURL = [info objectForKey:UIImagePickerControllerReferenceURL];
            NSLog(@"ReferenceURL: %@", referenceURL);
            
            // Save uncropped image to Documents folder with the same UUID and extension
            NSString *UUID = [self valueForKey:@"id" inAssetsLibraryURL:referenceURL];
            NSString *ext = [self valueForKey:@"ext" inAssetsLibraryURL:referenceURL];
            filename = [UUID stringByAppendingPathExtension:[ext lowercaseString]];
        }
        
        // Save image to file system and add to currentProject object
        mediaSavePath = [documentsPath stringByAppendingPathComponent:filename];
        [self writeImage:image toPath:mediaSavePath];
        
        // Set thumbnail image for title view
        [self setThumbnailFromImage:image toPath:mediaSavePath];
        
        // Update server
        [self uploadMediafile:mediaSavePath fileName:filename toProjectWithID:self.currentProject.identifier];
        //[self updateCurrentProject];
    }
    
    // If media type is moive
//    if ( [ mediaType isEqualToString:(NSString *)kUTTypeMovie ])
//    {
//        NSURL *movieURL = [info objectForKey:UIImagePickerControllerMediaURL];
//        NSString *moviePath = [movieURL path];
//        NSString *filename;
//        
//        NSLog(@"movieURL: %@", movieURL);
//        
//        if (picker == self.takePhotoPicker) {
//            
//             // Save unedited movie to Camera Roll album
//            if (UIVideoAtPathIsCompatibleWithSavedPhotosAlbum (moviePath)) {
//                UISaveVideoAtPathToSavedPhotosAlbum(moviePath, self, @selector(image:didFinishSavingWithError:ContextInfo:), @"movie");
//            }
//            
//            // Save unedited movie to Documents folder with newly generated UUID.MOV
//            NSString *UUID = [NSString stringWithUUID];
//            filename = [UUID stringByAppendingPathExtension:@"mov"];
//           
//        }
//        
//        // Choose movie from library
//        if (picker == self.choosePhotoPicker) {
//            
//            // Get UUID of selected Photo or Movie
//            NSURL *referenceURL = [info objectForKey:UIImagePickerControllerReferenceURL];
//            NSLog(@"ReferenceURL: %@", referenceURL);
//            
//            // Save unedited movie to Documents folder with the same UUID and extension
//            NSString *UUID = [self valueForKey:@"id" inAssetsLibraryURL:referenceURL];
//            NSString *ext = [self valueForKey:@"ext" inAssetsLibraryURL:referenceURL];
//            filename = [UUID stringByAppendingPathExtension:[ext lowercaseString]];
//        }
//        
//        // Save image to file system and add to currentProject object
//        mediaSavePath = [documentsPath stringByAppendingPathComponent:filename];
//        [self saveMovieAtURL:movieURL toPath:mediaSavePath];
//        [self.currentProject.mediaFilesOfProject addObject:mediaSavePath];
//        
//        
//        // Set thumbnail image as the first frame of video
//        UIImage *firstFrame = [self thumbnailImageForVideo:movieURL atTime:0.0];
//        [self setThumbnailFromImage:firstFrame toPath:mediaSavePath];
//        
//        // Update plist
//        //[FABPlistHelper plistUpdateProjectAtIndexPath:self.currentProjectIndexPath WithObject:self.currentProject.mediaFilesOfProject ForKey:@"mediaFiles"];
//        //[FABPlistHelper plistUpdateProjectAtIndexPath:self.currentProjectIndexPath WithObject:self.currentProject.thumbnailFileOfProject ForKey:@"thumbnailFile"];
//        [self.delegate thumbnailDidChange];
//        
//        NSLog(@"mediaSavePath: %@", mediaSavePath);
//    }
    

    [self dismissModalViewControllerAnimated:YES];
    [self.cameraPickerPopover dismissPopoverAnimated:YES];
}


// Alerting the user if the image was NOT saved
- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error ContextInfo:(NSString *)mediaTypeInShort
{
    UIAlertView *alert;
    
    // Error message
    if(error) 
    {
        alert = [[UIAlertView alloc] initWithTitle:@"Error" 
                                           message:[NSString stringWithFormat:@"Unable to save %@ to Photo Album.", mediaTypeInShort] 
                                          delegate:self cancelButtonTitle:@"Ok" 
                                 otherButtonTitles:nil];
        [alert show];
        [alert release];
    }
}


#pragma mark - Photo/Movie processing

- (UIImage*)thumbnailImageForVideo:(NSURL *)videoURL atTime:(NSTimeInterval)time 
{
    AVURLAsset *asset = [[[AVURLAsset alloc] initWithURL:videoURL options:nil] autorelease];
    NSParameterAssert(asset);
    AVAssetImageGenerator *assetImageGenerator = [[[AVAssetImageGenerator alloc] initWithAsset:asset] autorelease];
    assetImageGenerator.appliesPreferredTrackTransform = YES;
    assetImageGenerator.apertureMode = AVAssetImageGeneratorApertureModeEncodedPixels;
    
    CGImageRef thumbnailImageRef = NULL;
    CFTimeInterval thumbnailImageTime = time;
    NSError *thumbnailImageGenerationError = nil;
    thumbnailImageRef = [assetImageGenerator copyCGImageAtTime:CMTimeMake(thumbnailImageTime, 60) actualTime:NULL error:&thumbnailImageGenerationError];
    
    if (!thumbnailImageRef)
        NSLog(@"thumbnailImageGenerationError %@", thumbnailImageGenerationError);
    
    UIImage *thumbnailImage = thumbnailImageRef ? [[[UIImage alloc] initWithCGImage:thumbnailImageRef] autorelease] : nil;
    
    return thumbnailImage;
}

- (NSString *)valueForKey:(NSString *)key inAssetsLibraryURL:(NSURL *)url
{
    NSString *query = [url query];
    
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    for (NSString *param in [query componentsSeparatedByString:@"&"]) {
        NSArray *elts = [param componentsSeparatedByString:@"="];
        if([elts count] < 2) continue;
        [params setObject:[elts objectAtIndex:1] forKey:[elts objectAtIndex:0]];
    }
    
    NSString *value = [params valueForKey:key];
    
    return value;
}

- (void)writeImage:(UIImage*)image toPath:(NSString *)path
{
    if (image != nil)
    {
        NSData* data = UIImageJPEGRepresentation(image, 0.95);
        [data writeToFile:path atomically:YES];
    }
}

- (void)saveMovieAtURL:(NSURL *)movieURL toPath:(NSString *)path
{
    NSData * data = [NSData dataWithContentsOfURL:movieURL];
    [data writeToFile:path atomically:YES];
}

#pragma mark -
#pragma mark KTPhotoBrowserDataSource

- (NSInteger)numberOfPhotos 
{
    return [self.currentProject.mediaFilesOfProject count];
}

- (NSData *)dataAtRemoteURLPath:(NSString *)path
{
    NSURLRequest *request=[NSURLRequest requestWithURL:[NSURL URLWithString:path]
                                           cachePolicy:NSURLRequestUseProtocolCachePolicy
                                       timeoutInterval:10.0];
    
    NSData *responseData = [NSURLConnection sendSynchronousRequest:request returningResponse:nil error:nil];
    return responseData;
}

- (UIImage *)imageAtRemoteURLPath:(NSString *)path
{
    NSData *responseData = [self dataAtRemoteURLPath:path];
    UIImage *image = [UIImage imageWithData:responseData];
    return image;
}

- (id)mediaAtIndex:(NSInteger)index
{
    FABMediafile *mediafile = [self.currentProject.mediaFilesOfProject objectAtIndex:index];
    NSString *path = [mediafile URL];
    NSString *MIMEtype = [mediafile type];
    
    
    if ([MIMEtype hasPrefix:@"mov"]) 
    {
        // Return movie URL
//        NSURL *url = [NSURL fileURLWithPath:path];
//        return url;
    }
    
    // Or Photo Image depends on its type
    if ([MIMEtype hasPrefix:@"image"])
    {
        UIImage *image = [self imageAtRemoteURLPath:path];
        return image;
    }
    
    return nil;
}

- (UIImage *)imageAtIndex:(NSInteger)index 
{
    FABMediafile *mediafile = [self.currentProject.mediaFilesOfProject objectAtIndex:index];
    NSString *path = [mediafile URL];
    UIImage *image = [self imageAtRemoteURLPath:path];
    
    return image;
}

- (UIImage *)thumbImageAtIndex:(NSInteger)index
{
    NSString *path = self.currentProject.thumbnailFileOfProject;
    UIImage *image = [self imageAtRemoteURLPath:path];    
    return image;
}

- (void)deleteImageAtIndex:(NSInteger)index 
{     
    FABMediafile *mediafile = [self.currentProject.mediaFilesOfProject objectAtIndex:index];
    
    // Make a copy of mediafile path, because mediafile is going to be removed
    NSString *path = [NSString stringWithString:[mediafile URL]];
    
    // Delete mediafile on server
    [self deleteMediafileWithID:mediafile.identifier];
    
    // Remove from curretProject
    [self.currentProject.mediaFilesOfProject removeObjectAtIndex:index];
    
    
    // Change thumbnail if it is deleted
    if ([path isEqualToString:self.currentProject.thumbnailFileOfProject]) 
    {
        UIImage *thumbnail = nil;
        NSString *thumbnailImagePath = @"";
        if ([self.currentProject.mediaFilesOfProject count]) 
        {
            FABMediafile *lastMediafile = [self.currentProject.mediaFilesOfProject lastObject];
            thumbnailImagePath = [lastMediafile URL];
            NSString *smallThumbnailPath = [thumbnailImagePath stringByAppendingFormat:@"/small"];
            thumbnail = [self imageAtRemoteURLPath:smallThumbnailPath];
        }

        [self.thumbnailButton setBackgroundImage:thumbnail forState:UIControlStateNormal];
        self.currentProject.thumbnailFileOfProject = thumbnailImagePath;    
    
        // Update server
        [self updateCurrentProject];
        
//        // Inform gallery view
//        [self.delegate thumbnailDidChange];
    }
    
    // Replace badge
    NSInteger numberOfMedia = [self.currentProject.mediaFilesOfProject count];
    [self replaceWithNewBadge:[CustomBadge badgeWithNumber:numberOfMedia]];
}

- (void)exportImageAtIndex:(NSInteger)index 
{
    FABMediafile *mediafile = [self.currentProject.mediaFilesOfProject objectAtIndex:index];
    NSString *path = [mediafile URL];
    
    if ([path isEqualToString:self.currentProject.thumbnailFileOfProject] == NO) 
    {
        NSString *samllThumbnailPath = [path stringByAppendingFormat:@"/small"];
        UIImage *thumbnail = [self imageAtRemoteURLPath:samllThumbnailPath];
        [self.thumbnailButton setBackgroundImage:thumbnail forState:UIControlStateNormal];
        self.currentProject.thumbnailFileOfProject = path;
        
        // Update server
        [self updateCurrentProject];
        
//        // Inform gallery view
//        [self.delegate thumbnailDidChange];
    }
}



#pragma mark - UISplitViewController delegations

- (void)splitViewController:(UISplitViewController *)splitController willHideViewController:(UIViewController *)viewController withBarButtonItem:(UIBarButtonItem *)barButtonItem forPopoverController:(UIPopoverController *)popoverController
{
    // From landscape to portrait
    barButtonItem.title = @"Projects";
    NSMutableArray *newItems = [self.toolBar.items mutableCopy];
    [newItems insertObject:barButtonItem atIndex:0];
    [self.toolBar setItems:newItems];
    [newItems release];
}

- (void)splitViewController:(UISplitViewController *)splitController willShowViewController:(UIViewController *)viewController invalidatingBarButtonItem:(UIBarButtonItem *)barButtonItem
{
    // From portrait to landscape
    NSMutableArray *newItems = [self.toolBar.items mutableCopy];
    [newItems removeObjectAtIndex:0];
    [self.toolBar setItems:newItems];
    [newItems release];
}

- (BOOL)splitViewController:(UISplitViewController *)svc shouldHideViewController:(UIViewController *)vc inOrientation:(UIInterfaceOrientation)orientation
{
    //return NO;
    return UIInterfaceOrientationIsPortrait(orientation);
}


@end