//
//  FABProjectsDetailViewController.h
//  Fabiji
//
//  Created by Zhao He on 06/02/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <RestKit/RestKit.h>
#import <AVFoundation/AVFoundation.h>
#import <AssetsLibrary/AssetsLibrary.h>
#import <MediaPlayer/MediaPlayer.h>
#import <MessageUI/MessageUI.h>
#import <MobileCoreServices/UTCoreTypes.h>
#import "FABProject.h"
#import "FABProjectsSectionViewController.h"
#import "FABMailComposer.h"
#import "UIView+RoundedBoarder.h"
#import "UIImage+Processing.h"
#import "CustomBadge.h"
#import "NSString+Utility.h"
#import "KTPhotoBrowserDataSource.h"
#import "KTPhotoScrollViewController.h"


@protocol FABProjectThumbnailDelegate
- (void)thumbnailDidChange;
@end


@interface FABProjectsDetailViewController : UIViewController 
<UISplitViewControllerDelegate, UITextViewDelegate, UINavigationControllerDelegate, UIImagePickerControllerDelegate, UIActionSheetDelegate, MFMailComposeViewControllerDelegate, KTPhotoBrowserDataSource, RKObjectLoaderDelegate, UIAlertViewDelegate>

@property (retain, nonatomic) FABUser *currentUser;
@property (retain, nonatomic) FABProject *currentProject;
@property (retain, nonatomic) CustomBadge *numberBadge;
@property (retain, nonatomic) UIActionSheet *currentActionSheet;
@property (retain, nonatomic) UIActionSheet *cameraActionSheet;
@property (retain, nonatomic) UIActionSheet *exportActionSheet;
@property (retain, nonatomic) UIActionSheet *configActionSheet;
@property (retain, nonatomic) UIPopoverController *cameraPickerPopover;
@property (retain, nonatomic) UIImagePickerController *takePhotoPicker;
@property (retain, nonatomic) UIImagePickerController *choosePhotoPicker;
@property (retain, nonatomic) FABProjectsSectionViewController *sectionTableView;

@property (retain, nonatomic) IBOutlet UIToolbar *toolBar;
@property (retain, nonatomic) IBOutlet UIBarButtonItem *toolBarTitleButtonItem;
@property (retain, nonatomic) IBOutlet UIBarButtonItem *cameraBarButtonItem;
@property (retain, nonatomic) IBOutlet UIBarButtonItem *exportBarButtonItem;
@property (retain, nonatomic) IBOutlet UIBarButtonItem *configBarButtonItem;
@property (retain, nonatomic) IBOutlet UIScrollView *scrollView;
@property (retain, nonatomic) IBOutlet UIButton *thumbnailButton;
@property (retain, nonatomic) IBOutlet UIImageView *logInHintView;

@property (assign, nonatomic) id <FABProjectThumbnailDelegate> delegate;

- (IBAction)thumbnailButtonTapped:(id)sender;
- (IBAction)cameraButtonTapped:(id)sender;
- (IBAction)exportButtonTapped:(id)sender;
- (IBAction)configButtonTapped:(id)sender;


- (void)logInAsTapped;
- (void)configureView;
- (void)cameraPopover;
- (void)writeImage:(UIImage*)image toPath:(NSString *)path;
- (void)saveMovieAtURL:(NSURL *)movieURL toPath:(NSString *)path;
- (void)replaceWithNewBadge:(CustomBadge *)badge;

- (NSString *)valueForKey:(NSString *)key inAssetsLibraryURL:(NSURL *)url;
- (UIImage*)thumbnailImageForVideo:(NSURL *)videoURL atTime:(NSTimeInterval)time;


@end

