//
//  FABProjectGuideStep6ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/12/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep6ViewController.h"
#import "FABProjectsListViewController.h"

@implementation FABProjectGuideStep6ViewController

@synthesize project = _project;


// Lazy instantiation
- (FABProject *)project
{
    if ( !_project ) {
        _project = [[FABProject alloc] init];
    }
    return _project;
}

- (void)dealloc 
{
    [_project release];
    [super dealloc];
}


- (IBAction)cancelButtonTapped:(id)sender 
{   
    NSLog(@"cancelButtonTapped:");
    
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    // return to project tab
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)backButtonTapped:(id)sender 
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction)nextButtonTapped:(id)sender 
{
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    // Pop back to project split view
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:YES];

    
    //   master --
    //            |-- navigation ---
    //     list --                  |--- split view
    //                    detail ---
    //
    UISplitViewController *splitVC = [navigationController.viewControllers objectAtIndex:0];
    UINavigationController *navVC = [splitVC.viewControllers objectAtIndex:0];
    FABProjectsListViewController *masterVC = [navVC.viewControllers lastObject];
    
    // add new project to FABProjectsListViewController
    [masterVC addNewProject:self.project];
}


#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

@end
