//
//  FABProjectGuideStep5ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/12/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep5ViewController.h"

@implementation FABProjectGuideStep5ViewController

@synthesize project = _project;
@synthesize addFileTextField;


// Lazy instantiation
- (FABProject *)project
{
    if ( !_project ) {
        _project = [[FABProject alloc] init];
    }
    return _project;
}

- (void)dealloc {
    [addFileTextField release];
    [super dealloc];
}

- (IBAction)cancelButtonTapped:(id)sender 
{   
    NSLog(@"cancelButtonTapped:");
    
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)backButtonTapped:(id)sender 
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction)nextButtonTapped:(id)sender 
{
    FABProjectGuideStep6ViewController *step6ViewController = [[FABProjectGuideStep6ViewController alloc] init];
    step6ViewController.project = self.project;
    [self.navigationController pushViewController:step6ViewController animated:YES];
    [step6ViewController release];
}



#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // Add rounded border for UITextField
    [self.addFileTextField addRoundedBorder];
}

- (void)viewDidUnload
{
    [self setAddFileTextField:nil];
    [super viewDidUnload];
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
	return YES;
}

@end
