//
//  FABProjectGuideStep4ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/12/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep4ViewController.h"
#import "FABProjectGuideStep6ViewController.h"
#import "FABLicense.h"
#import "NSArray+NameContents.h"

@interface FABProjectGuideStep4ViewController()

@property (retain, nonatomic) NSArray *availableLicenses;
@property (retain, nonatomic) NSArray *availableTags;

@end

@implementation FABProjectGuideStep4ViewController

@synthesize project = _project;
@synthesize availableLicenses = _availableLicenses;
@synthesize availableTags = _availableTags;
@synthesize pickerPopoverController = _pickerPopoverController;
@synthesize licenseTextField = _licenseTextField;
@synthesize scrollView = _scrollView;
@synthesize tagsView = _tagsView;
@synthesize tagsTokenFieldView = _tokenFieldView;
@synthesize tagsHintLabel = _tagsHintLabel;

- (id)init
{
    self = [super init];
    if (self)
    {
        self.project = [[[FABProject alloc] init] autorelease];
        [self loadLicenses];
        [self loadTags];
    }
    return self;
}

- (void)dealloc
{
    [_project release];
    [_availableLicenses release];
    [_pickerPopoverController release];
    [_licenseTextField release];
    [_scrollView release];
    [_tagsView release];
    [_tagsHintLabel release];
    [super dealloc];
}


#pragma mark - RestKit

- (void)loadLicenses
{
    // GET /licenses
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/licenses" delegate:self];
}

- (void)loadTags
{
    // GET /tags
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/tags" delegate:self];
}

- (void)request:(RKRequest*)request didLoadResponse:(RKResponse*)response 
{
//    NSLog(@"Response: %@", [response bodyAsString]);
//    NSLog(@"Status: %d", [response statusCode]);
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didLoadObjects:(NSArray *)objects 
{
	//NSLog(@"Loaded object: %@", objects);
    if ( [objectLoader.resourcePath isEqualToString:@"/licenses"] ) {
        self.availableLicenses = objects;
    }
    
    if ([objectLoader.resourcePath isEqualToString:@"/tags"]) 
    {
        // Set up source array
        self.availableTags = [objects nameContentsArray];
        self.tagsTokenFieldView.sourceArray = self.availableTags;
    }
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}



#pragma mark - IBActions

- (IBAction)cancelButtonTapped:(id)sender 
{   
    NSLog(@"cancelButtonTapped:");
    
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)backButtonTapped:(id)sender 
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction)nextButtonTapped:(id)sender 
{ 
    [[[UIApplication sharedApplication] keyWindow] endEditing:YES];
    //self.project.licenseOfProject = self.licenseTextField.text;
    self.project.tagsOfProject = [NSMutableArray arrayWithArray:self.tagsTokenFieldView.tokenTitles];
    
    FABProjectGuideStep6ViewController *step6ViewController = [[FABProjectGuideStep6ViewController alloc] init];
    step6ViewController.project = self.project;
    [self.navigationController pushViewController:step6ViewController animated:YES];
    [step6ViewController release];
}


#pragma mark - UITextField delegation

- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    if (textField == self.licenseTextField)
    {
        NSMutableArray *availableLicenseContents = [[[NSMutableArray alloc] init] autorelease];
        // Prepare contents
        for (FABLicense *license in self.availableLicenses) {
            [availableLicenseContents addObject:license.name];
        }
        
        // Create picker
        FABPickerViewController *picker = [[FABPickerViewController alloc] initWithTitle:nil TableViewContents:availableLicenseContents icons:nil];
        picker.delegate = self;
        
        // Pop over available tools
        self.pickerPopoverController = [[[UIPopoverController alloc] initWithContentViewController:picker] autorelease];
        self.pickerPopoverController.popoverContentSize = CGSizeMake(400, 44 * [self.availableLicenses count]);
        CGRect rect = self.licenseTextField.bounds;         
        [self.pickerPopoverController presentPopoverFromRect:rect inView:self.licenseTextField permittedArrowDirections:UIPopoverArrowDirectionAny animated:YES];
        [picker release];
    }
    
    if (textField == self.tagsTokenFieldView.tokenField)
    {
        if (self.tagsHintLabel.hidden == NO) {
            self.tagsHintLabel.hidden = YES;
        }
    }
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    if (self.tagsTokenFieldView.tokenTitles.count == 0) {
        self.tagsHintLabel.hidden = NO;
    }
}


#pragma mark - FABPickerViewController delegation

//- (void)pickerContentAtRowSelected:(NSString *)content
- (void)pickerRowSelected:(int)row
{    
    // Update selected license
    FABLicense *selectedLicense = [self.availableLicenses objectAtIndex:row];
    self.licenseTextField.text = selectedLicense.name;
    
    // Update current project
    self.project.licenseOfProject = selectedLicense;
    
    // dismiss picker view
    [self.pickerPopoverController dismissPopoverAnimated:YES];
    self.pickerPopoverController = nil;
}


#pragma mark - View lifecycle

- (void)setupTokenFieldView
{
    self.tagsTokenFieldView = [[[TITokenFieldView alloc] initWithFrame:self.tagsView.frame] autorelease];
    self.tagsTokenFieldView.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    
    self.tagsTokenFieldView.scrollEnabled = NO;
    self.tagsTokenFieldView.tokenField.font = [UIFont systemFontOfSize:17];
    self.tagsTokenFieldView.tokenField.textColor = [UIColor darkTextColor];
    [self.tagsTokenFieldView addSubview:self.tagsHintLabel];
    [self.scrollView addSubview:self.tagsTokenFieldView];
    self.tagsTokenFieldView.tokenField.delegate = self;
    [self.tagsTokenFieldView.tokenField setPromptText:@""];
	[self.tagsTokenFieldView.tokenField setTokenizingCharacters:[NSCharacterSet characterSetWithCharactersInString:@",;."]]; // Default is a comma
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // Add rounded border for UITextField
    [self.licenseTextField addRoundedBorder];
    [self setupTokenFieldView];
    [self.tagsTokenFieldView addRoundedBorder];
}

- (void)viewDidUnload
{
    [self setLicenseTextField:nil];
    [self setScrollView:nil];
    [self setTagsView:nil];
    [self setTagsHintLabel:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
	return YES;
}


@end
