//
//  FABProjectGuideStep3ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/12/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep3ViewController.h"
#import "NSArray+NameContents.h"
#import "TITokenFieldView+Utility.h"

@interface FABProjectGuideStep3ViewController()

@property (retain, nonatomic) NSArray *availableTools;
@property (retain, nonatomic) NSArray *availableMaterials;

@end

@implementation FABProjectGuideStep3ViewController

@synthesize project = _project;
@synthesize availableTools = _availableTools;
@synthesize availableMaterials = _availableMaterials;
@synthesize toolsTokenFieldView = _toolsTokenFieldView;
@synthesize materialsTokenFieldView = _materialsTokenFieldView;
@synthesize materialsView = _materialsView;
@synthesize materialsHintLabel = _materialsHitLabel;
@synthesize scrollView = _scrollView;
@synthesize toolsView = _toolsView;
@synthesize toolsHintLabel = _toolsHintLabel;


- (id)init
{
    self = [super init];
    if (self)
    {
        self.project = [[[FABProject alloc] init] autorelease];
        [self loadTools];
        [self loadMaterials];
    }
    return self;
}

- (void)dealloc 
{
    [_project release];
    [_availableTools release];
    [_availableMaterials release];
    [_materialsView release];
    [_materialsHitLabel release];
    [_scrollView release];
    [_toolsView release];
    [_toolsHintLabel release];
    [super dealloc];
}

#pragma mark - RestKit

- (void)loadTools
{
    // GET /tools
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/tools" delegate:self];
}

- (void)loadMaterials
{
    // GET /materials
    [[RKObjectManager sharedManager] loadObjectsAtResourcePath:@"/materials" delegate:self];
}

- (void)request:(RKRequest*)request didLoadResponse:(RKResponse*)response 
{
    NSLog(@"Response: %@", [response bodyAsString]);
    NSLog(@"Status: %d", [response statusCode]);
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didLoadObjects:(NSArray *)objects 
{
	NSLog(@"Loaded object: %@", objects);
    if ([objectLoader.resourcePath isEqualToString:@"/tools"]) 
    {
        // Set up source array
        self.availableTools = [objects nameContentsArray];
        self.toolsTokenFieldView.sourceArray = self.availableTools;
    }
    
    else if ([objectLoader.resourcePath isEqualToString:@"/materials"]) 
    {
        // Set up source array
        self.availableMaterials = [objects nameContentsArray];
        self.materialsTokenFieldView.sourceArray = self.availableMaterials;
    }
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}


#pragma mark - IBActions

- (IBAction)cancelButtonTapped:(id)sender 
{   
    NSLog(@"cancelButtonTapped:");
    
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)backButtonTapped:(id)sender 
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction)nextButtonTapped:(id)sender 
{
    self.project.toolsOfProject = [NSMutableArray arrayWithObject:self.toolsTokenFieldView.tokenTitles];
    self.project.materialsOfProject = [NSMutableArray arrayWithArray:self.materialsTokenFieldView.tokenTitles];
    
    FABProjectGuideStep4ViewController *step4ViewController = [[FABProjectGuideStep4ViewController alloc] init];
    step4ViewController.project = self.project;
    [self.navigationController pushViewController:step4ViewController animated:YES];
    [step4ViewController release];
}



#pragma mark - UITextField delegation

- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    if (textField == self.toolsTokenFieldView.tokenField)
    {
        if (self.toolsHintLabel.hidden == NO) {
            self.toolsHintLabel.hidden = YES;
        }
    }
    
    else if (textField == self.materialsTokenFieldView.tokenField)
    {
        if (self.materialsHintLabel.hidden == NO) {
            self.materialsHintLabel.hidden = YES;
        }
    }
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    if (self.toolsTokenFieldView.tokenTitles.count == 0) {
        self.toolsHintLabel.hidden = NO;
    }
    else if (self.toolsTokenFieldView.tokenTitles.count == 0) {
        self.toolsHintLabel.hidden = NO;
    }
}


#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // Create toolsTokenFieldView
    self.toolsTokenFieldView = [[TITokenFieldView alloc] initWithFrame:self.toolsView.frame];
    [self.toolsTokenFieldView addSubview:self.toolsHintLabel];
    self.toolsTokenFieldView.tokenField.delegate = self;
    [self.toolsTokenFieldView setupWithParentView:self.scrollView sourceArray:nil placeHolderView:nil];
    
    // Create materialsTokenFieldView
    self.materialsTokenFieldView = [[TITokenFieldView alloc] initWithFrame:self.materialsView.frame];
    [self.materialsTokenFieldView addSubview:self.materialsHintLabel];
    self.materialsTokenFieldView.tokenField.delegate = self;
    [self.materialsTokenFieldView setupWithParentView:self.scrollView sourceArray:nil placeHolderView:nil];
    
    [self.toolsTokenFieldView addRoundedBorder];
    [self.materialsTokenFieldView addRoundedBorder];
}

- (void)viewDidUnload
{
    [self setMaterialsView:nil];
    [self setMaterialsHintLabel:nil];
    [self setScrollView:nil];
    [self setToolsView:nil];
    [self setToolsHintLabel:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}


@end
