//
//  FABProjectGuideStep2ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/9/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep2ViewController.h"

@implementation FABProjectGuideStep2ViewController

@synthesize project = _project;
@synthesize descriptionTextView;


// Lazy instantiation
- (FABProject *)project
{
    if ( !_project ) {
        _project = [[FABProject alloc] init];
    }
    return _project;
}

- (void)dealloc 
{
    [_project release];
    [descriptionTextView release];
    [super dealloc];
}

- (IBAction)cancelButtonTapped:(id)sender 
{   
    NSLog(@"cancelButtonTapped:");
    
    UINavigationController *navigationController = self.navigationController;
    
    // retain ourselves so that the controller will still exist once it's popped off
    [[self retain] autorelease];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [navigationController popViewControllerAnimated:NO];
    [navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)backButtonTapped:(id)sender 
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction)nextButtonTapped:(id)sender 
{
    self.project.descriptionOfProject = self.descriptionTextView.text;
    
    FABProjectGuideStep3ViewController *step3ViewController = [[FABProjectGuideStep3ViewController alloc] init];
    step3ViewController.project = self.project;
    [self.navigationController pushViewController:step3ViewController animated:YES];
    [step3ViewController release];
}



#pragma mark - View lifecycle


- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self.descriptionTextView addRoundedBorder];
    //self.descriptionTextView.placeholder = @"e.g. A photo booth with LED stripes intended for taking better pictures with iPad";
    self.descriptionTextView.placeholderColor = [UIColor lightGrayColor];

}

- (void)viewDidUnload
{
    [self setDescriptionTextView:nil];
    [super viewDidUnload];
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}



@end
