//
//  FABProjectGuideStep1ViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/8/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABProjectGuideStep1ViewController.h"
#import "FABCalendarMasterViewController.h"

@implementation FABProjectGuideStep1ViewController

@synthesize project = _project;
@synthesize projectNameTextField = _projectNameTextField;

// Lazy instantiation
- (FABProject *)project
{
    if ( !_project ) {
        _project = [[FABProject alloc] init];
    }
    return _project;
}

- (void)dealloc 
{
    [_project release];
    [_projectNameTextField release];
    [super dealloc];
}

# pragma mark - IBActions
- (IBAction)cancelButtonTapped:(id)sender
{
    NSLog(@"cancelButtonTapped:");
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:.4];
    [UIView setAnimationBeginsFromCurrentState:YES];        
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromRight forView:self.navigationController.view cache:NO];
    [self.navigationController popViewControllerAnimated:NO];
    [UIView commitAnimations];
}

- (IBAction)nextButtonTapped:(id)sender 
{
    if ([self.projectNameTextField.text length])
    {
        self.project.titleOfProject = self.projectNameTextField.text;
        
        FABProjectGuideStep2ViewController *step2ViewController = [[FABProjectGuideStep2ViewController alloc] init];
        step2ViewController.project = self.project;
        [self.navigationController pushViewController:step2ViewController animated:YES];
        [step2ViewController release];
    }

}


# pragma mark - Suggested title

- (NSString *)scheduledEventTitle
{
    // Find FABCalendarMasterViewController
    UISplitViewController *calendarSplitViewController = [self.navigationController.tabBarController.viewControllers objectAtIndex:0];
    UINavigationController *navigationController = [calendarSplitViewController.viewControllers objectAtIndex:0];
    FABCalendarMasterViewController *calendarMasterViewController = [navigationController.viewControllers objectAtIndex:0];
    
    // Find current scheduled event
    NSDate *now = [NSDate date];
    NSString *str = @"";
    
    for (EKEvent *event in calendarMasterViewController.events) 
    {
        if (([now compare:event.startDate] == NSOrderedDescending) &&
            ([now compare:event.endDate] == NSOrderedAscending)) {
            
            str = event.title;
            break;
        }
    }
    
    return str;
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self.projectNameTextField addRoundedBorder];
    self.projectNameTextField.text = [self scheduledEventTitle];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    [self setProjectNameTextField:nil];
}

#pragma mark - UITextField delegation
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    textField.textColor = [UIColor blackColor];
}

// Process enter key
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self nextButtonTapped:self];
    return NO;
}



- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}



@end
