//
//  FABDocument.h
//  Fabiji
//
//  Created by Zhao He on 18/02/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FABLicense.h"

@interface FABProject : NSObject

@property (nonatomic, retain) NSNumber *identifier;
@property (nonatomic, copy) NSString *titleOfProject;
@property (nonatomic, copy) NSString *descriptionOfProject;
@property (nonatomic, retain) NSMutableArray *toolsOfProject;
@property (nonatomic, retain) NSMutableArray *materialsOfProject;
@property (nonatomic, retain) FABLicense *licenseOfProject;
@property (nonatomic, retain) NSMutableArray *tagsOfProject;
@property (nonatomic, retain) NSMutableArray *mediaFilesOfProject;
@property (nonatomic, copy) NSString *thumbnailFileOfProject; // = [mediafile URL]

// Note: 
// All elements in mediaFilesOfProject are used in KTPhotoBrowser. So if audio is included
// in mediaFilesOfProject, KTPhotoBrowser should be able to display audio files.

@end
