//
//  FABPlistHelper.m
//  Fabiji
//
//  Created by Zhao He on 3/1/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABPlistHelper.h"

@implementation FABPlistHelper

+ (NSArray *)availableTools
{
    NSString *path = [[NSBundle mainBundle] pathForResource:@"FabTools" ofType:@"plist"];
    NSDictionary *plistData = [[NSDictionary dictionaryWithContentsOfFile:path] retain];
    NSArray *availableTools = [plistData objectForKey:@"tools"];
    
    return availableTools;
}

+ (NSArray *)availableLicenses
{
    NSString *path = [[NSBundle mainBundle] pathForResource:@"FabLicenses" ofType:@"plist"];
    NSDictionary *plistData = [[NSDictionary dictionaryWithContentsOfFile:path] retain];
    NSArray *availableLicenses = [plistData objectForKey:@"licenses"];

    return availableLicenses;
}

+ (NSArray *)licensesIcons
{
    UIImage *CC_BY_NC_ND = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"CC_BY_NC_ND" ofType:@"png"]];
    UIImage *freebsd = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"freebsd" ofType:@"png"]];
    UIImage *publicdomain = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"publicdomain" ofType:@"png"]];
    UIImage *copyright = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"copyright" ofType:@"png"]];
        
    NSArray *licensesIcons = [NSArray arrayWithObjects:CC_BY_NC_ND, freebsd, publicdomain, copyright, nil];
    
    return licensesIcons;
}

+ (NSString *)databasePlistPath
{
    NSString *path = [[NSString stringWithDocumentsPath] stringByAppendingPathComponent:@"database.plist"];
    
    if ( !path ) {
        NSLog(@"Error: Can't find database.plist in Documents folder: %@", path);
        return nil;
    }
    return path;
}

+ (NSMutableArray *)plistLoadData
{
    NSString *plistPath = [self databasePlistPath];
    
    if ( !plistPath ) {
        return nil;
    }
    
    NSDictionary *plistData = [[NSDictionary dictionaryWithContentsOfFile:plistPath] retain];
    NSArray *usersArray = [plistData objectForKey:@"users"];
    NSMutableArray *users = [[NSMutableArray alloc] init];
    
    // Load user
    for (NSDictionary *userData in usersArray) 
    {
        FABUser *user = [[FABUser alloc] init];
        user.fullname = [userData objectForKey:@"fullname"];
        NSArray *projectsArray = [userData objectForKey:@"projects"];
        
        // Load project
        for (NSDictionary *projectData in projectsArray) 
        {
            FABProject *project = [[FABProject alloc] init];
            
            NSString *name = [projectData objectForKey:@"name"];
            NSString *descrption = [projectData objectForKey:@"description"];
            NSMutableArray *tools = [NSMutableArray arrayWithArray:[projectData objectForKey:@"tools"]];
            NSMutableArray *materials = [NSMutableArray arrayWithArray:[projectData objectForKey:@"materials"]];
            //NSString *license = [projectData objectForKey:@"license"];
            NSMutableArray *tags = [NSMutableArray arrayWithArray:[projectData objectForKey:@"tags"]];
            NSMutableArray *mediaFiles = [NSMutableArray arrayWithArray:[projectData objectForKey:@"mediaFiles"]];
            NSString *thumbnailFile = [projectData objectForKey:@"thumbnailFile"];
            
            if (name) project.titleOfProject = name;
            if (descrption) project.descriptionOfProject = descrption;
            if (tools) project.toolsOfProject = tools;
            if (materials) project.materialsOfProject = materials;
            //if (license) project.licenseOfProject = license;
            if (tags) project.tagsOfProject = tags;
            if (mediaFiles) project.mediaFilesOfProject = mediaFiles;
            if (thumbnailFile) project.thumbnailFileOfProject = thumbnailFile;
            
            [user.projects addObject:project];
        }
        
        [users addObject:user];
    }
    
    return [users autorelease];
}

+ (void)plistUpdateProjectAtIndexPath:(NSIndexPath *)indexPath WithObject:(id)obj ForKey:(NSString *)key
{
    NSString *plistPath = [self databasePlistPath];
    
    if ( !plistPath ) {
        return;
    }
    
    // Load dictionary data from plist
    NSInteger currentUserIndex = [indexPath section];
    NSInteger currentProjectIndex = [indexPath row];
    
    NSMutableDictionary *plistDict = [[NSMutableDictionary dictionaryWithContentsOfFile:plistPath] retain];
    NSMutableArray *usersArray = [NSMutableArray arrayWithArray:[plistDict objectForKey:@"users"]];
    NSMutableDictionary *currentUser = [NSMutableDictionary dictionaryWithDictionary:[usersArray objectAtIndex:currentUserIndex]];
    NSMutableArray *projectsArray = [NSMutableArray arrayWithArray:[currentUser objectForKey:@"projects"]];
    NSMutableDictionary *currentProject = [NSMutableDictionary dictionaryWithDictionary:[projectsArray objectAtIndex:currentProjectIndex]];
    
    // Modify project
    [currentProject setObject:obj forKey:key];
    
    
    // Construct new dictionary data
    [projectsArray replaceObjectAtIndex:currentProjectIndex withObject:currentProject];
    [currentUser setObject:projectsArray forKey:@"projects"];
    [usersArray replaceObjectAtIndex:currentUserIndex withObject:currentUser];
    [plistDict setObject:usersArray forKey:@"users"];
    
    // Save dictionary data to plist
    NSString *error;
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:plistDict
                                                                   format:NSPropertyListXMLFormat_v1_0
                                                         errorDescription:&error];
    if(plistData) {
        [plistData writeToFile:plistPath atomically:YES];
    }
    else {
        NSLog(@"%@", error);
        [error release];
    }
}


+ (void)plistAddProject:(FABProject *)project toUserAtIndex:(NSInteger)userIndex
{
    NSString *plistPath = [self databasePlistPath];
    
    if ( !plistPath ) {
        return;
    }
    
    // Load dictionary data from plist
    NSMutableDictionary *plistDict = [[NSMutableDictionary dictionaryWithContentsOfFile:plistPath] retain];
    NSMutableArray *usersArray = [NSMutableArray arrayWithArray:[plistDict objectForKey:@"users"]];
    NSMutableDictionary *currentUser = [NSMutableDictionary dictionaryWithDictionary:[usersArray objectAtIndex:userIndex]];
    NSMutableArray *projectsArray = [NSMutableArray arrayWithArray:[currentUser objectForKey:@"projects"]];
    
    
   // Store project into dictionary
    NSArray *objects = [NSArray arrayWithObjects:project.titleOfProject, project.descriptionOfProject, project.toolsOfProject, project.materialsOfProject, project.licenseOfProject, project.tagsOfProject, project.mediaFilesOfProject, project.thumbnailFileOfProject, nil];
    NSArray *keys = [NSArray arrayWithObjects:@"name", @"descrption", @"tools", @"materials", @"license", @"tags", @"mediaFiles", @"thumbnailFile", nil];
    NSDictionary *projectDict = [NSDictionary dictionaryWithObjects:objects forKeys:keys];
    
    // Modify projects array
    [projectsArray addObject:projectDict];
    
    // Construct new dictionary data
    [currentUser setObject:projectsArray forKey:@"projects"];
    [usersArray replaceObjectAtIndex:userIndex withObject:currentUser];
    [plistDict setObject:usersArray forKey:@"users"];
    
    // Save dictionary data to plist
    NSString *error;
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:plistDict
                                                                   format:NSPropertyListXMLFormat_v1_0
                                                         errorDescription:&error];
    if(plistData) {
        [plistData writeToFile:plistPath atomically:YES];
    }
    else {
        NSLog(@"%@", error);
        [error release];
    }
}

+ (void)plistAddUser:(FABUser *)user
{
    NSString *plistPath = [self databasePlistPath];
    
    if ( !plistPath ) {
        return;
    }
    
    // Load dictionary data from plist
    NSMutableDictionary *plistDict = [[NSMutableDictionary dictionaryWithContentsOfFile:plistPath] retain];
    NSMutableArray *usersArray = [NSMutableArray arrayWithArray:[plistDict objectForKey:@"users"]];
   
    // Store user into dictionary
    NSDictionary *userDict = [NSDictionary dictionaryWithObject:user.fullname forKey:@"fullname"];
    
    // Modify users array
    [usersArray addObject:userDict];
    
    // Construct new dictionary data
    [plistDict setObject:usersArray forKey:@"users"];
    
    // Save dictionary data to plist
    NSString *error;
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:plistDict
                                                                   format:NSPropertyListXMLFormat_v1_0
                                                         errorDescription:&error];
    if(plistData) {
        [plistData writeToFile:plistPath atomically:YES];
    }
    else {
        NSLog(@"%@", error);
        [error release];
    }
}


@end
