//
//  FABSharePickerViewController.m
//  Fabiji
//
//  Created by Zhao He on 2/7/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABPickerViewController.h"

@implementation FABPickerViewController

@synthesize tableViewContents = _tableViewContents;
@synthesize tableViewIcons = _tableViewIcons;
@synthesize delegate = _delegate;

- (id)init {
    self = [super init];
    if (self) {
        [self initWithTitle:@"Title" TableViewContents:nil icons:nil];
    }
    return self;
}

- (id)initWithTitle:(NSString *)title TableViewContents:(NSArray *)contents icons:(NSArray *)icons
{
    self = [super init];
    if (self) {
        self.title = title;
        self.tableViewContents = contents;
        self.tableViewIcons = icons;
    }
    return self;
}

- (void)dealloc 
{
    _tableViewContents = nil;
    _tableViewIcons = nil;
    _delegate = nil;
    [super dealloc];
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    //self.tableView.scrollEnabled = NO;
    //self.contentSizeForViewInPopover = CGSizeMake(200, 180);
    self.contentSizeForViewInPopover = CGSizeMake(180, 44 * [self.tableViewContents count]);
    
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.tableViewContents count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
    }
    
    if (self.tableViewContents)
    {
        cell.textLabel.text = [self.tableViewContents objectAtIndex:indexPath.row];
    }
    
    if (self.tableViewIcons) 
    {
        cell.imageView.image = [self.tableViewIcons objectAtIndex:indexPath.row];
    }
    
    return cell;
}

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self.delegate respondsToSelector:@selector(pickerContentAtRowSelected:)]) 
    {
        [self.delegate pickerContentAtRowSelected:[self.tableViewContents objectAtIndex:indexPath.row]];
    }
    
    else if ([self.delegate respondsToSelector:@selector(pickerRowSelected:)])
    {
        [self.delegate pickerRowSelected:indexPath.row];
    }
}


@end
