//
//  FABMailComposeViewController.m
//  Fabiji
//
//  Created by Zhao He on 12/03/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABMailComposer.h"
#import "FABTool.h"
#import "FABMaterial.h"
#import "FABLicense.h"
#import "FABTag.h"

@implementation FABMailComposer

@synthesize subject;
@synthesize messageBody;

- (id)init
{
    self = [super init];
    if (self) {
        self.subject = @"";
        self.messageBody = @"";
    }
    return self;
}


- (id)initWithProject:(FABProject *)project
{
    self = [super init];
    if (self)
    {
        NSString *description = project.descriptionOfProject;
        NSMutableString *tools = [NSMutableString stringWithString:@""];
        for (FABTool *tool in project.toolsOfProject) {
            tools = [NSMutableString stringWithFormat:@"%@ %@", tools, tool.name];
        }
        NSMutableString *materials = [NSMutableString stringWithString:@""];
        for (FABMaterial *material in project.materialsOfProject) {
            materials = [NSMutableString stringWithFormat:@"%@ %@", materials, material.name];
        }
        NSString *license = project.licenseOfProject.name;
        NSMutableString *tags = [NSMutableString stringWithString:@""];
        for (FABTag *tag in project.tagsOfProject) {
            tags = [NSMutableString stringWithFormat:@"%@ %@", tags, tag.name];
        }
        
        self.subject = project.titleOfProject;
        self.messageBody = [NSString stringWithFormat:@"Description: %@\nTools: %@\nMaterials: %@\nLicense: %@\nTags: %@", description, tools, materials, license, tags];
    }
    return self;
}

@end
