//
//  FABGallerySinglePageViewController.m
//  Fabiji
//
//  Created by Zhao He on 03/02/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABGallerySinglePageViewController.h"
#import "FABMediafile.h"

static NSString* const FABCommentChoice = @"Comment";

@implementation FABGallerySinglePageViewController

@synthesize projects = _projects;
@synthesize selectedProject = _selectedProject;
@synthesize imageButtonCollection = _imageViewCollection;


- (void)dealloc 
{
    [_projects release];
    [_selectedProject release];
    [_imageViewCollection release];
    [super dealloc];
}


- (void)setProjects:(NSArray *)projects
{
    if (_projects != projects) {
        [_projects release]; 
        _projects = [projects retain]; 
        
        // Update the view.
        [self configureView];
    }
}



#pragma mark - IBActions

- (IBAction)detailButtonTapped:(id)sender
{
    NSLog(@"detailButtonTapped:");
    UIViewController *photoViewController = [self.view.superview viewController];
    
    // Create a new detailViewController
    FABProjectsDetailViewController *detailViewController = [[FABProjectsDetailViewController alloc] init];
    detailViewController.currentProject = self.selectedProject;
    detailViewController.title = self.selectedProject.titleOfProject;
    
    // Push the detailViewController onto the navigation stack
    [photoViewController.navigationController pushViewController:detailViewController animated:YES];
    photoViewController.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    
    // Remove toolbar from detailViewController
    [detailViewController.toolBar removeFromSuperview];
    [detailViewController release];
}

- (IBAction)imageButtonAction:(id)sender 
{
    self.selectedProject = [self.projects objectAtIndex:[sender tag]];
    UIViewController *photoViewController = [self.view.superview viewController];
    KTPhotoScrollViewController *photoBrowserController = [[KTPhotoScrollViewController alloc] 
                                                           initWithDataSource:self 
                                                           andStartWithPhotoAtIndex:self.selectedProject.mediaFilesOfProject.count-1];
    
    // Add detail button on the right
    UIBarButtonItem *detailButton = [[UIBarButtonItem alloc] initWithTitle:@"Detail" style:UIBarButtonItemStylePlain target:self action:@selector(detailButtonTapped:)];
    photoBrowserController.navigationItem.rightBarButtonItem = detailButton;
    
    [photoViewController.navigationItem setTitle:@"Gallery"];
    [photoViewController.navigationController pushViewController:photoBrowserController animated:YES];
    
    [detailButton release];
    [photoBrowserController release];
}


#pragma mark - configure View


- (NSData *)dataAtRemoteURLPath:(NSString *)path
{
    NSURLRequest *request=[NSURLRequest requestWithURL:[NSURL URLWithString:path]
                                           cachePolicy:NSURLRequestUseProtocolCachePolicy
                                       timeoutInterval:10.0];
    
    NSData *responseData = [NSURLConnection sendSynchronousRequest:request returningResponse:nil error:nil];
    return responseData;
}

- (UIImage *)imageAtRemoteURLPath:(NSString *)path
{
    NSData *responseData = [self dataAtRemoteURLPath:path];
    UIImage *image = [UIImage imageWithData:responseData];
    return image;
}

- (void)configureView
{ 
    for (int i = 0; i < self.projects.count; i++) 
    {
        UIButton *imageButton = [self.imageButtonCollection objectAtIndex:i];
        FABProject *project = [self.projects objectAtIndex:i];
        NSString *imagePath = [project.thumbnailFileOfProject stringByAppendingFormat:@"/medium"];
            
        imageButton.hidden = NO;
        [imageButton setBackgroundImage:[self imageAtRemoteURLPath:imagePath] forState:UIControlStateNormal];
        [self createRoundedCorner:[self.imageButtonCollection objectAtIndex:i]];
    }
}


- (void)createRoundedCorner:(UIImageView *)imageView
{
    // Create the path (with only the top-left corner rounded)
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:imageView.bounds
                                                   byRoundingCorners:UIRectCornerAllCorners
                                                         cornerRadii:CGSizeMake(20, 20)];
    
    // Create the shape layer and set its path
    CAShapeLayer *maskLayer = [CAShapeLayer layer];
    maskLayer.frame = imageView.bounds;
    maskLayer.path = maskPath.CGPath;
    
    // Set the newly created shape layer as the mask for the image view's layer
    imageView.layer.mask = maskLayer;
}



#pragma mark -
#pragma mark KTPhotoBrowserDataSource

- (NSInteger)numberOfPhotos 
{
    return [self.selectedProject.mediaFilesOfProject count];
}


- (id)mediaAtIndex:(NSInteger)index
{    
    FABMediafile *mediafile = [self.selectedProject.mediaFilesOfProject objectAtIndex:index];
    NSString *path = [mediafile URL];
    NSString *MIMEtype = [mediafile type];
    
    if ([MIMEtype hasPrefix:@"mov"]) 
    {
        // Return movie URL
//        NSURL *url = [NSURL fileURLWithPath:path];
//        return url;
    }
    
    // Or Photo Image depends on its type
    if ([MIMEtype hasPrefix:@"image"])
    {
        UIImage *image = [self imageAtRemoteURLPath:path];
        return image;
    }
    
    return nil;
}

- (UIImage *)imageAtIndex:(NSInteger)index 
{
    FABMediafile *mediafile = [self.selectedProject.mediaFilesOfProject objectAtIndex:index];
    NSString *path = [mediafile URL];
    UIImage *image = [self imageAtRemoteURLPath:path];
    
    return image;
}

//- (void)exportImageAtIndex:(NSInteger)index 
//{
//    NSLog(@"comment");
//}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

- (void)viewDidUnload 
{
    
    [self setImageButtonCollection:nil];
    [super viewDidUnload];
}
@end
