//
//  FABGalleryPhotoViewController.h
//  Fabiji
//
//  Created by Zhao He on 1/31/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <RestKit/RestKit.h>
#import <QuartzCore/QuartzCore.h>
#import "FABGallerySinglePageViewController.h"
#import "FABProjectsDetailViewController.h"
#import "FABPlistHelper.h"
#import "UIPageControl+BackStyle.h"
#import "UIView+ViewController.h"
#import "FABSearchController.h"

@interface FABGalleryPhotoViewController : UIViewController <UIScrollViewDelegate, FABProjectThumbnailDelegate, RKObjectLoaderDelegate>

@property (assign, nonatomic) BOOL pageControlIsChangingPage;

@property (retain, nonatomic) IBOutlet UIScrollView *scrollView;
@property (retain, nonatomic) IBOutlet UIPageControl *pageControl;
@property (retain, nonatomic) IBOutlet UISearchBar *searchBar;
@property (retain, nonatomic) IBOutlet FABSearchController *searchController;

- (IBAction)changePage;

- (void)setupSearchControllerWithProjects:(NSArray *)projects;
- (void)setupPojectThumbnailDelegate;
- (void)setupScrollViewsAndPages;
- (void)alignSubviews;

@end
