//
//  FABModalHelper.m
//  Fabiji
//
//  Created by Zhao He on 01/05/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABConfigHelper.h"
#import "FABProjectsListViewController.h"

@interface FABConfigHelper()
+ (UIViewController *)signupFromViewController;
+ (void)addUsers:(NSArray *)users online:(BOOL)status toSection:(QSection *)userSection withParentViewController:(UIViewController *)parent currentUser:(FABUser *)currentUser;
@end

@implementation FABConfigHelper

static FABConfigHelper *sharedConfigHelper = nil;

#pragma mark - Public methods

+ (FABConfigHelper *)sharedConfigHelper
{
    if (sharedConfigHelper == nil) {
        sharedConfigHelper = [[super allocWithZone:NULL] init];
    }
    
    return sharedConfigHelper;
}

+ (void)presentLoginFromViewController:(UIViewController *)parent withUsers:(NSArray *)users currentUser:(FABUser *)currentUser
{
    QRootElement *root = [[[QRootElement alloc] init] autorelease];
    root.grouped = YES;
    QSection *userSection = [[[QSection alloc] init] autorelease];
    QSection *buttonSection = [[[QSection alloc] init] autorelease];
    
    // Add current user
    if (currentUser) 
    {
        QBadgeElement *badge = [[[QBadgeElement alloc] initWithTitle:currentUser.fullname Value:nil] autorelease];
        badge.badge = @"me";
        badge.badgeColor = [UIColor redColor];
        [userSection addElement:badge];
    }

    
    NSArray *sortedArray = [users sortedArrayUsingSelector:@selector(compare:)];
    
    [self addUsers:sortedArray online:YES toSection:userSection withParentViewController:parent currentUser:currentUser];
    [self addUsers:sortedArray online:NO toSection:userSection withParentViewController:parent currentUser:currentUser];

    buttonSection.footer = @"All data is saved before logging in.";
    
    // Create a sign up button for new users
    QButtonElement *signUpButton = [[[QButtonElement alloc] initWithTitle:@"Need to Sign Up?"] autorelease];
    signUpButton.enabled = YES;
    signUpButton.controllerAction = @"needToSignUpAction:";
    
    // Add sections
    [root addSection:buttonSection];
    [root addSection:userSection];
    [buttonSection addElement:signUpButton];
    
    // Create a loginController with left bar button item as Cancel
    QuickDialogController *loginController = [QuickDialogController controllerForRoot:root];
    loginController.navigationItem.title = @"Log In As";
    loginController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"Cancel" style:UIBarButtonItemStylePlain target:loginController action:@selector(cancelButtonTapped:)];
    
    // Wrap loginController in a navigation controller and display it modally
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:loginController];
    nav.modalPresentationStyle = UIModalPresentationFormSheet;
    [parent presentModalViewController:nav animated:YES];
}

+ (void)presentCurrentUsersViewController:(UIViewController *)parent withUsers:(NSArray *)users
{
    QRootElement *root = [[[QRootElement alloc] init] autorelease];
    root.grouped = YES;
    QSection *userSection = [[[QSection alloc] init] autorelease];
    
    NSArray *sortedArray = [users sortedArrayUsingSelector:@selector(compare:)];
    
    for (FABUser *user in sortedArray) 
    {        
        // Display only users who are currently in the lab
        if ([user.status boolValue] == YES) 
        {
            QBadgeElement *badge = [[[QBadgeElement alloc] initWithTitle:user.fullname Value:@"on"] autorelease];
            badge.badgeColor = [UIColor orangeColor];
            [userSection addElement:badge];
        }
    }
    
    // Set the footer string for section
    NSString *footerText;
    if (userSection.elements.count > 1) {
        footerText = [NSString stringWithFormat:@"Currently %d people are working at the fab lab.", userSection.elements.count];
    }
    else {
        footerText = [NSString stringWithFormat:@"Currently %d person is working at the fab lab.", userSection.elements.count];
    }
    userSection.footer = footerText;
    
    // Add section to root
    [root addSection:userSection];
    
    // Create a loginController with left bar button item as Cancel
    QuickDialogController *loginController = [QuickDialogController controllerForRoot:root];
    loginController.navigationItem.title = @"Current Users";
    loginController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"Cancel" style:UIBarButtonItemStylePlain target:loginController action:@selector(cancelButtonTapped:)];
    
    // Wrap loginController in a navigation controller and display it modally
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:loginController];
    nav.modalPresentationStyle = UIModalPresentationFormSheet;
    [parent presentModalViewController:nav animated:YES];
}



#pragma mark - RestKit

+ (void)updateUser:(FABUser *)user withStatus:(NSNumber *)status
{
    user.status = status;
    
    // PUT to /users/uid
    [[RKObjectManager sharedManager] putObject:user delegate:[FABConfigHelper sharedConfigHelper]];
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}


#pragma mark - Private methods

+ (void)addUsers:(NSArray *)users online:(BOOL)status toSection:(QSection *)userSection withParentViewController:(UIViewController *)parent currentUser:(FABUser *)currentUser;
{
    for (FABUser *user in users) 
    {        
        QBadgeElement *badge = [[[QBadgeElement alloc] initWithTitle:user.fullname Value:nil] autorelease];
        badge.controllerAction = @"dumbAction:";
        badge.onSelected =  ^{
            // Dismiss curret modal view
            [parent dismissModalViewControllerAnimated:YES];
            
            // Login new user
            if ([user.status boolValue] == NO) {
                [self updateUser:user withStatus:[NSNumber numberWithBool:YES]];
            }
            
            // Select new user
            UINavigationController *navigationController = [parent.splitViewController.viewControllers objectAtIndex:0];
            FABProjectsListViewController *listVC = [navigationController.viewControllers objectAtIndex:1];
            listVC.currentUser = user;
        };
        
        if ([user.status boolValue] == YES) {
            badge.badge = @"on";
            badge.badgeColor = [UIColor orangeColor];
        }
        
        else {
            badge.badge = @"off";
            badge.badgeColor = [UIColor lightGrayColor];
        }

        // Add online or offline users
        if ([user.status boolValue] == status && [user.identifier isEqual:currentUser.identifier] == NO) {
            [userSection addElement:badge];
        }
    }
}


+ (UIViewController *)signupFromViewController
{
    QRootElement *root = [[[QRootElement alloc] init] autorelease];
    root.grouped = YES;
    QSection *entrySection = [[[QSection alloc] init] autorelease];
    QSection *buttonSection = [[[QSection alloc] init] autorelease];
    
    QEntryElement *name = [[QEntryElement alloc] initWithTitle:@"Name" Value:nil Placeholder:@"Max Mustermann"];
    name.autocorrectionType = UITextAutocorrectionTypeNo;
    name.autocapitalizationType = UITextAutocapitalizationTypeWords;
    name.keyboardType = UIKeyboardTypeNamePhonePad;
    name.key = @"fullname";
    
    QEntryElement *email = [[QEntryElement alloc] initWithTitle:@"Email" Value:nil Placeholder:@"max@mustermann.de"]; 
    email.autocorrectionType = UITextAutocorrectionTypeNo;
    email.autocapitalizationType = UITextAutocapitalizationTypeNone;
    email.keyboardType = UIKeyboardTypeEmailAddress;
    email.key = @"email";
    
    QButtonElement *signUpButton = [[[QButtonElement alloc] initWithTitle:@"Sign Up" Value:nil] autorelease];
    signUpButton.enabled = YES;
    signUpButton.controllerAction = @"signUpButtonTapped:";
    
    [root addSection:entrySection];
    [root addSection:buttonSection];
    [entrySection addElement:name];
    [entrySection addElement:email];
    [buttonSection addElement:signUpButton];
    
    QuickDialogController *loginController = [QuickDialogController controllerForRoot:root];
    loginController.navigationItem.title = @"Join Fabiji";
    loginController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"Cancel" style:UIBarButtonItemStylePlain target:loginController action:@selector(cancelButtonTapped:)];
    
    return loginController;
}

#pragma mark - Singleton

// We can still have a regular init method, that will get called the first time the Singleton is used.
- (id)init
{
    self = [super init];
    
    if (self) {
        // Work your initialising magic here as you normally would
    }
    
    return self;
}

// Your dealloc method will never be called, as the singleton survives for the duration of your app.
// However, I like to include it so I know what memory I'm using (and incase, one day, I convert away from Singleton).
- (void)dealloc
{
    // I'm never called!
    [super dealloc];
}

// We don't want to allocate a new instance, so return the current one.
+ (FABConfigHelper *)allocWithZone:(NSZone*)zone {
    return [[self sharedConfigHelper] retain];
}

// Equally, we don't want to generate multiple copies of the singleton.
- (FABConfigHelper *)copyWithZone:(NSZone *)zone {
    return self;
}

// Once again - do nothing, as we don't have a retain counter for this object.
- (FABConfigHelper *)retain {
    return self;
}

// Replace the retain counter so we can never release this object.
- (NSUInteger)retainCount {
    return NSUIntegerMax;
}

// This function is empty, as we don't want to let the user release this object.
- (oneway void)release {
    
}

//Do nothing, other than return the shared instance - as this is expected from autorelease.
- (FABConfigHelper *)autorelease {
    return self;
}

@end


#pragma mark - Extenstion actions

@interface QuickDialogController(Action) <RKObjectLoaderDelegate>

- (void)signUpButtonTapped:(id)sender;
- (void)cancelButtonTapped:(id)sender;
- (void)needToSignUpAction:(id)sender;
- (void)dumbAction:(id)sender;
@end

@implementation QuickDialogController(Action)

- (void)signUpButtonTapped:(id)sender
{    
    NSLog(@"sender: %@", sender);
    [[[UIApplication sharedApplication] keyWindow] endEditing:YES];
    
    FABUser *user = [[[FABUser alloc] init] autorelease];
    [self.root fetchValueIntoObject:user];
    
    // Create new user at server
    [self signUpUser:user];
}

- (void)cancelButtonTapped:(id)sender
{
    [self dismissModalViewControllerAnimated:YES];
}

- (void)needToSignUpAction:(id)sender
{
    [self.navigationController pushViewController:[FABConfigHelper signupFromViewController] animated:YES];
}

- (void)dumbAction:(id)sender;
{
    // dumbAction just to place a detail indicator on the cell
}



#pragma mark - RestKit

- (void)signUpUser:(FABUser *)user
{    
    // Set user status to be online
    user.status = [NSNumber numberWithBool:YES];
    
    // POST to /users
    [[RKObjectManager sharedManager] postObject:user delegate:self];
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didLoadObjects:(NSArray *)objects 
{
	NSLog(@"Loaded object: %@", objects);
    
    // :signUpUser
    FABUser *user = [objects objectAtIndex:0];
    
    // Dismiss current modal view
    [self dismissModalViewControllerAnimated:YES];
    
    // Select new user
    UITabBarController *tabBarController = (UITabBarController *)[self presentingViewController];
    UISplitViewController *splitVC = [[[[tabBarController viewControllers] objectAtIndex:3] viewControllers] objectAtIndex:0];
    UINavigationController *navigationController = [[splitVC viewControllers] objectAtIndex:0];
    FABProjectsListViewController *listVC = [navigationController.viewControllers objectAtIndex:1];
    listVC.currentUser = user;
    FABProjectsDetailViewController *detailVC = [splitVC.viewControllers lastObject];
    detailVC.logInHintView.hidden = YES;
}

- (void)objectLoader:(RKObjectLoader*)objectLoader didFailWithError:(NSError*)error {
	UIAlertView* alert = [[[UIAlertView alloc] initWithTitle:@"Error" message:[error localizedDescription] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil] autorelease];
	[alert show];
	NSLog(@"Hit error: %@", error);
}




@end


